/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#include "load_param_description.h"

#include "multi_type.h"
#include <stdarg.h>
#include "stdlibincl.h"
/**
 * @param paramName the name of the parameter to load
 */
LoadParamDescription::LoadParamDescription(const std::string& paramName)
{
  this->types = NULL;
  this->defaultValues = NULL;
  this->paramName = paramName;
}

/**
 *  removes all the alocated memory
 */
LoadParamDescription::~LoadParamDescription()
{
  if (this->defaultValues != NULL)
  {
    for(int i = 0; i < this->paramCount; i++)
    {
      delete[] this->defaultValues[i];
    }
  }

  delete[] this->types;
  delete[] this->defaultValues;
}

/**
 * @param descriptionText The text to set as a description for this Parameter
 */
void LoadParamDescription::setDescription(const std::string& descriptionText)
{
  this->description = descriptionText;
}

/**
 *  prints out this parameter, its input method and the description (if availiable)
 */
void LoadParamDescription::print() const
{
  PRINT(3)(" <%s>", this->paramName.c_str());
  for (int i = 0; i < this->paramCount; i++)
  {
    if (i > 0)
      PRINT(3)(",");
    // FIXME
    //     switch (this->types[i])
//     {
//       default:
//         PRINTF(3)("none");
//         break;
//       case ParameterBool:
//         PRINT(3)("bool");
//         break;
//       case ParameterChar:
//         PRINT(3)("char");
//         break;
//       case ParameterString:
//         PRINT(3)("string");
//         break;
//       case ParameterInt:
//         PRINT(3)("int");
//         break;
//       case ParameterUInt:
//         PRINT(3)("Uint");
//         break;
//       case ParameterFloat:
//         PRINT(3)("float");
//         break;
//       case ParameterLong:
//         PRINT(3)("long");
//         break;
//       case ParameterXML:
//         PRINT(3)("XML");
//         break;
//     }
  }
  PRINT(3)("</%s>", this->paramName.c_str());
  if (!this->description.empty())
    PRINT(3)(" -- %s", this->description.c_str());
  // default values
  if (this->paramCount > 0)
  {
    PRINT(3)(" (Default: ");
    for (int i = 0; i < this->paramCount; i++)
    {
      if (i > 0)
        PRINT(3)(", ");
      if (this->types[i] & MT_STRING)
      { // leave brackets !!
        PRINT(3)("\"%s\"", this->defaultValues[i]);
      }
      else
      {
        PRINT(3)("%s", this->defaultValues[i]);
      }
    }
    PRINT(3)(")");
  }
  PRINT(3)("\n");
}

/**
 *  A list, that holds all the classes that are loadable (classes not objects!!)
 */
std::list<LoadClassDescription*>* LoadClassDescription::classList = NULL;

/**
 *  if the description of Parameters should be executed
 */
bool LoadClassDescription::parametersDescription = false;

/**
 * @param className the name of the class to be loadable
 */
LoadClassDescription::LoadClassDescription(const std::string& className)
{
  this->className = className;

  if (LoadClassDescription::classList == NULL)
    LoadClassDescription::classList = new std::list<LoadClassDescription*>;

  LoadClassDescription::classList->push_back(this);
}

/**
 *  deletes a classDescription (deletes all the parameterDescriptions as well
 */
LoadClassDescription::~LoadClassDescription()
{
  std::list<LoadParamDescription*>::iterator it = this->paramList.begin();
  while (!this->paramList.empty())
  {
    delete this->paramList.front();
    this->paramList.pop_front();
  }
}

void LoadClassDescription::deleteAllDescriptions()
{
  if (LoadClassDescription::classList != NULL)
  {
    while (!LoadClassDescription::classList->empty())
    {
      delete LoadClassDescription::classList->front();
      LoadClassDescription::classList->pop_front();
    }
    delete LoadClassDescription::classList;
  }
  LoadClassDescription::classList = NULL;
}


/**
 *  adds a class to the list of loadable classes
 * @param className The name of the class to add

   this function searches for the className string, and if found just returns the appropriate Class.
   Otherwise it returns a new classDescription
 */
LoadClassDescription* LoadClassDescription::addClass(const std::string& className)
{
  if (LoadClassDescription::classList != NULL)
  {
    std::list<LoadClassDescription*>::iterator it = LoadClassDescription::classList->begin();
    while (it != LoadClassDescription::classList->end())
    {
      if ((*it)->className == className)
      {
        return (*it);
      }
      it++;
    }
  }
  return new LoadClassDescription(className);
}

/**
 *  does the same as addClass(const std::string& className), but with params
 * @param paramName the name of the parameter to add.
 */
LoadParamDescription* LoadClassDescription::addParam(const std::string& paramName)
{
  std::list<LoadParamDescription*>::iterator it = this->paramList.begin();
  while (it != this->paramList.end())
  {
    if ((*it)->paramName == paramName)
    {
      return NULL;
    }
    it++;
  }

  LoadParamDescription* newParam = new LoadParamDescription(paramName);

  this->paramList.push_back(newParam);
  return newParam;
}

/**
 *  prints out all loadable Classes, and their parameters
 * @param fileName prints the output to a File
 * @todo implement it
 */
void LoadClassDescription::printAll(const std::string& fileName)
{
  PRINT(3)("===============================================================\n");
  PRINT(3)(" Listing all the Loadable Options (loaded since Game started).\n\n");
  if (LoadClassDescription::classList != NULL)
  {
    std::list<LoadClassDescription*>::iterator classDesc = LoadClassDescription::classList->begin();
    while (classDesc != LoadClassDescription::classList->end())
    {
      PRINT(3)("<%s>\n", (*classDesc)->className.c_str());
      std::list<LoadParamDescription*>::iterator param = (*classDesc)->paramList.begin();
      while (param != (*classDesc)->paramList.end())
      {
        (*param)->print();
        param++;
      }
      PRINT(3)("</%s>\n\n", (*classDesc)->className.c_str());
      classDesc++;
    }
  }
  else
    PRINT(3)("no Classes defined so far\n");
  PRINT(3)("===============================================================\n");
}

/**
 * searches for classes, which beginn with classNameBegin
 * @param classNameBegin the beginning string of a Class
 * @return a NEW char-array with ClassNames. The LIST should be deleted afterwards,
 * !! The strings MUST NOT be deleted !!
 */
std::list<std::string> LoadClassDescription::searchClassWithShort(const std::string& classNameBegin)
{
  /// FIXME
  // NOT USED
/*  unsigned int searchLength = strlen(classNameBegin);
  std::list<const std::string&> retVal;

  tIterator<LoadClassDescription>* iterator = LoadClassDescription::classList->getIterator();
  LoadClassDescription* enumClassDesc = iterator->firstElement();
  while (enumClassDesc)
  {
    if (strlen(enumClassDesc->className)>searchLength+1 &&
        !strncasecmp(enumClassDesc->className, classNameBegin, searchLength))
    {
      retVal->add(enumClassDesc->className);
    }
    enumClassDesc = iterator->nextElement();
  }
  delete iterator;

  return retVal;*/
  std::list<std::string> a;
  return a;
}
