/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_handler.h"
#include "event_handler.h"

#include "glgui_mainwidget.h"
#include "glgui_cursor.h"

#include "class_list.h"


/// TAKE THIS OUT OF HERE.
#include "graphics_engine.h"

namespace OrxGui
{

  /**
   * standard constructor
   */
  GLGuiHandler::GLGuiHandler ()
  {
    this->setClassID(CL_GLGUI_HANDLER, "GLGuiHandler");
    this->setName("GLGuiHandler");


    EventHandler::getInstance()->withUNICODE(ES_ALL, true );

    this->cursor = NULL;
    for (unsigned int i = 0; i < EV_NUMBER; i++)
    {
      this->subscribeEvent(ES_ALL, i);
    }
  }

  /**
   *  the singleton reference to this class
   */
  GLGuiHandler* GLGuiHandler::singletonRef = NULL;

  /**
     @brief standard deconstructor
   */
  GLGuiHandler::~GLGuiHandler ()
  {
    GLGuiHandler::singletonRef = NULL;
  }

  void GLGuiHandler::activateCursor()
  {
    if (this->cursor == NULL)
      this->cursor = new GLGuiCursor();
    this->cursor->show();
    this->cursor->setMaxBorders(Vector2D(GraphicsEngine::getInstance()->getResolutionX(), GraphicsEngine::getInstance()->getResolutionY()));
  }

  void GLGuiHandler::deactivateCursor(bool deleteCursor)
  {
    if (this->cursor)
    {
      if (deleteCursor)
        delete this->cursor;
      this->cursor = NULL;
    }
  }


  void GLGuiHandler::activate()
  {
    EventHandler::getInstance()->pushState(ES_MENU);



  }

  void GLGuiHandler::deactivate()
  {
    EventHandler::getInstance()->popState();


  }


  void GLGuiHandler::process(const Event &event)
  {
    switch (event.type)
    {
      case  EV_MOUSE_BUTTON_LEFT:
        if (GLGuiWidget::focused() != NULL)
        {
          if (event.bPressed)
          {
            if (GLGuiWidget::focused()->clickable())
            {
              Vector2D cursorPos = (this->cursor != NULL) ? this->cursor->getAbsCoor2D() : Vector2D(event.x, event.y);
              GLGuiWidget::focused()->click(cursorPos - GLGuiWidget::focused()->getAbsCoor2D());
            }
          }
          else
          {
            if (GLGuiWidget::focused()->clickable())
            {
              Vector2D cursorPos = (this->cursor != NULL) ? this->cursor->getAbsCoor2D() : Vector2D(event.x, event.y);
              GLGuiWidget::focused()->release(cursorPos - GLGuiWidget::focused()->getAbsCoor2D());
            }
          }
        }
        break;
      case EV_LEAVE_STATE:
        if (GLGuiWidget::focused() != NULL)
          GLGuiWidget::focused()->breakFocus();
        break;

      case EV_VIDEO_RESIZE:
        if (this->cursor != NULL)
          this->cursor->setMaxBorders(Vector2D(event.resize.w, event.resize.h));
        break;
    }



    if (GLGuiWidget::focused())
    {
      GLGuiWidget::focused()->processEvent(event);
    }



  }


  Vector2D GLGuiHandler::cursorPositionOverFocusedWidget() const
  {
    return (this->cursor != NULL) ? this->cursor->getAbsCoor2D() : Vector2D(0,0);
  }

  const Vector2D& GLGuiHandler::cursorPositionAbs() const
  {
    if (this->cursor)
      return this->cursor->getAbsCoor2D();
    else
      return Vector2D::nullVector();
  }
  Vector2D GLGuiHandler::cursorPositionRel(const GLGuiWidget* const widget) const
  {
    assert (widget != NULL);
    if (this->cursor)
      return  this->cursor->getAbsCoor2D() - widget->getAbsCoor2D();
    else
      return Vector2D::nullVector();
  }


  void GLGuiHandler::draw()
  {
    //    GLGuiMainWidget::getInstance()->draw2D(E2D_LAYER_TOP);
  }


  void GLGuiHandler::tick(float dt)
  {

    // CHECK THE COLLISIONS.
    const std::list<BaseObject*>* objects = ClassList::getList(CL_GLGUI_WIDGET);

    if (objects != NULL && this->cursor != NULL)
    {
      for (std::list<BaseObject*>::const_iterator it = objects->begin(); it != objects->end(); it++)
      {
        GLGuiWidget* widget = dynamic_cast<GLGuiWidget*>(*it);

        if (widget->isVisible() &&
            widget->focusable() &&
            widget->focusOverWidget(this->cursor))
        {
          // receiving Focus
          if (GLGuiWidget::focused() != widget)
          {
            widget->giveFocus();
          }
          return ;
        }
      }
      if (GLGuiWidget::focused() != NULL)
        GLGuiWidget::focused()->breakFocus();
    }
  }
}
