/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_cursor.h"

#include "glgui_handler.h"
#include "color.h"
#include "texture_sequence.h"
#include "loading/resource_manager.h" // HACK

namespace OrxGui
{

  /**
   * standard constructor
  */
  GLGuiCursor::GLGuiCursor ()
  {
    this->init();

    this->subscribeEvent(ES_ALL,  EV_MOUSE_MOTION);
    this->subscribeEvent(ES_ALL, EV_WINDOW_FOCUS);


  }


  /**
   * @brief standard deconstructor
   */
  GLGuiCursor::~GLGuiCursor()
  {
    GLGuiHandler::getInstance()->deactivateCursor(false);
  }

  float GLGuiCursor::_mouseSensitivity = 1.0;



  /**
   * @brief initializes the GUI-element
   */
  void GLGuiCursor::init()
  {
    this->setClassID(CL_GLGUI_CURSOR, "GLGuiCursor");

    this->backMaterial().setDiffuse(1.0,0.0,0.0);
    this->backMaterial().setDiffuseMap("cursor.png");
    this->backMaterial().setBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    this->setSize2D(50, 50);
    this->setAbsCoor2D(100, 100);
    this->setLayer(E2D_LAYER_ABOVE_ALL);
    this->color = 0.0f;

    this->seq = new TextureSequence();
    this->seq->loadImageSeries(ResourceManager::getInstance()->getDataDir() + "/maps/reap_mouse/reap_mouse_##.tif", 0, 49);

    this->resize();
  }

  void GLGuiCursor::tick(float dt)
  {
    this->frameNumber += 25.0*dt;
    if (frameNumber >= this->seq->getFrameCount())
      frameNumber = 0.0;

    this->color += dt*10.0;
    if (this->color > 360.0)
      this->color -= 360.0;
    Vector color =  Color::HSVtoRGB(Vector(this->color, 1.0, 1.0));
    this->backMaterial().setDiffuse(color.x, color.y, color.z);

    //if (this->movement != Vector2D())
    {
      newPos += movement;
      // reposition the cursor.
      if (newPos.x < 0.0f )
        newPos.x = 0.0f;
      if (newPos.x > this->_maxBorders.x)
        newPos.x = this->_maxBorders.x;
      if (newPos.y < 0.0f )
        newPos.y = 0.0f;
      if (newPos.y > this->_maxBorders.y)
        newPos.y = this->_maxBorders.y;


      movement = Vector2D();
    }
    this->setAbsCoor2D(newPos);
  }

  /**
   * @brief draws the GLGuiCursor
   */
  void GLGuiCursor::draw() const
  {
    this->beginDraw();
    // HACK
    glActiveTexture(GL_TEXTURE0);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, this->seq->getFrameTexture((int)frameNumber));
    glColor3f(1,1,1);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    this->drawRect(this->backRect());

    //GLGuiWidget::draw();
    this->endDraw();
  }

  void GLGuiCursor::process(const Event& event)
  {
    switch (event.type)
    {
      case EV_WINDOW_FOCUS:
        if (event.bPressed)
        {
          int mouseX, mouseY;
          SDL_GetMouseState(&mouseX, &mouseY);
          newPos = Vector2D(mouseX, mouseY);
        }
        break;
      case EV_MOUSE_MOTION:
        movement += Vector2D((float)event.xRel * _mouseSensitivity, (float)event.yRel * _mouseSensitivity);
        break;

    }
  }
}
