/*!
 * @file texture_sequence.h
 * @brief Contains the texture_sequence class, that handles the reading of Image-files into multiple Texutres.
 */

#ifndef _TEXTURE_SEQUENCE_H
#define _TEXTURE_SEQUENCE_H

#include "texture.h"

#include <vector>


//! A Class, that reads in Textures from different fileformats.
class TextureSequence : public Texture
{
  public:
    TextureSequence(unsigned int count = 0, ...);
    TextureSequence(const std::vector<std::string>*& textureNames);
    //  Texture(TEXTURE_TYPE type, int resolution);
    virtual ~TextureSequence();

    bool loadImageSeries(unsigned int count, ...);
    bool loadImageSeries(unsigned int count, std::vector<std::string>& textureNames);
    bool loadImageSeries(const std::string& imagePrefix, unsigned int from, unsigned int to);
    bool addFrame(const std::string& image);
    bool addFrame(SDL_Surface* surface);
    bool addFrame(GLuint texture);

    void clearLists();

    virtual bool rebuild();

    /** @returns the count of frames in this sequence */
    inline unsigned int getFrameCount() const { return this->textures.size(); };

    //void gotoFrame(unsigned int frameNumber);
    /** @returns The textureID of the Frame @param frameNumber the n-th frame this texture-series.  */
    inline GLuint getFrameTexture(unsigned int frameNumber) const { return (this->textures.size()>frameNumber)?this->textures[frameNumber]:0; };
    /** @returns The SDL_Surface of the image at Frame @param frameNumber the n-th frame of this image-seriers */
    const SDL_Surface* const getFrameImage(unsigned int frameNumber) const { return (this->images.size()>frameNumber)?this->images[frameNumber]:NULL; };

  private:
    std::vector<GLuint>          textures;            //!< The Texture-ID of opengl from this Texture.
    std::vector<SDL_Surface*>    images;              //!< The SDL_Surfce that stores the Texture on it.
};

#endif /* _TEXTURE_SEQUENCE_H */
