/*!
 * @file script_class.h
 * @brief Definition of ...
*/

#ifndef _SCRIPT_CLASS_H
#define _SCRIPT_CLASS_H

#include "base_object.h"

#include "script.h"
#include "lunar.h"

// FORWARD DECLARATION


/**
 * Creates a factory to a Loadable Class.
 * this should be used at the beginning of all the Classes that should be loadable (in the cc-file)
 */
#define CREATE_SCRIPTABLE_CLASS(CLASS_NAME, CLASS_ID) \
    tScriptable<CLASS_NAME> global_##CLASS_NAME##_ScriptableClass(#CLASS_NAME, CLASS_ID)



//! A class for ...
class ScriptClass : protected BaseObject
{

  public:
    virtual ~ScriptClass();

    bool operator==(const std::string& name) { return (this->getName() == name); }
    bool operator==(ClassID classID) { return (this->classID == classID); }

    virtual void registerClass(Script* script) = 0;
    virtual int insertObject(Script* L, BaseObject* obj, bool gc=false) = 0;

  protected:
    ScriptClass(const std::string& name, ClassID classID);

  private:
    ClassID             classID;
};




template <class T>
class tScriptable : public ScriptClass
{
  public:
    tScriptable(const std::string& name, ClassID classID)
        : ScriptClass(name, classID)
    { }

    virtual void registerClass(Script* script)
    {
      Lunar<T>::Register(script);
    }
    virtual int insertObject(Script* L, BaseObject* obj, bool gc=false)
    {
      return Lunar<T>::insertObject(L, dynamic_cast<T*>(obj), obj->getName(), gc);
    }



}
;


#endif /* _SCRIPT_CLASS_H */
