//for testing
#include "luaincl.h"
#include "script_trigger.h"
#include "class_list.h"
#include "script.h"

#include "state.h"
 
 
 
ScriptTrigger::ScriptTrigger(const TiXmlElement* root)
{
  this->setClassID(CL_SCRIPT_TRIGGER, "ScriptTrigger");
  this->toList(OM_COMMON);
  
  scriptCalled = false;
  scriptIsOk = false;
  loadParams(root);

  printf("scripttrigger generated\n");
}

ScriptTrigger::~ScriptTrigger()
{

}

void ScriptTrigger::loadParams(const TiXmlElement* root)
{
  if(root != NULL)
  {
    WorldEntity ::loadParams(root);

    LoadParam(root, "file", this, ScriptTrigger, setScript)
        .describe("the fileName of the script, that should be triggered by this script trigger")
        .defaultValues("");
    LoadParam(root, "function", this, ScriptTrigger, setFunction)
        .describe("the function of the script, that should be triggered by this script trigger")
        .defaultValues("");
    LoadParam(root, "abs-coor", this, ScriptTrigger, setAbsCoor)
        .describe("where this script trigger should be located")
        .defaultValues("");
    LoadParam(root, "radius", this, ScriptTrigger, setRadius)
        .describe("the fileName of the script, that should be triggered by this script trigger")
        .defaultValues(0);
    LoadParam(root, "delay", this, ScriptTrigger, setDelay)
        .describe("the delay after which the funtion sould be triggered")
        .defaultValues(0);
    LoadParam(root, "worldentity", this, ScriptTrigger, setTarget)
        .describe("The name of the target as it is in the *.oxw file")
        .defaultValues("");
    LoadParam(root, "triggerparent", this, ScriptTrigger, setTriggerParent)
        .describe("The name of the parent as it is in the *.oxw file")
        .defaultValues("");
    LoadParam(root, "callonce", this, ScriptTrigger, setCallOnce)
        .describe("True if the script shoul only be called once")
        .defaultValues("");
  }

}


void ScriptTrigger::setTarget(const std::string& target)
{
  BaseObject* targetEntity = ClassList::getObject(target, CL_WORLD_ENTITY);

  if (targetEntity != NULL)
  {
    this->setTarget(dynamic_cast<WorldEntity*>(targetEntity));
  }
  else
  {
    PRINTF(2)("Target %s for %s::%s does not Exist\n", target.c_str(), this->getClassName(), this->getName());
  }
}

void ScriptTrigger::setTriggerParent(const std::string& parent)
{
  BaseObject* parentEntity = ClassList::getObject(parent, CL_WORLD_ENTITY);

  if (parentEntity != NULL)
  {
    this->setParent(dynamic_cast<WorldEntity*>(parentEntity));
    this->setParentMode(PNODE_MOVEMENT);
  }
  else
  {
    PRINTF(2)("Parent %s for %s::%s does not Exist\n", parent.c_str(), this->getClassName(), this->getName());
  }
}

void ScriptTrigger::tick(float timestep)
{
  
 if((this->getAbsDirV()-target->getAbsDirV()).len() < radius)
 {
   printf("SCRIPTTRIGGER: condition met\n");
  if(!callOnce)
   {
    executeAction();
   }
  else if(callOnce && !scriptCalled)
  {
   executeAction();
   scriptCalled = true;
  }
 }

}


void ScriptTrigger::executeAction()
{
     if(scriptIsOk)
     {
       testScriptingFramework();
     if(!(script->selectFunction(this->functionName,0)) )
       printf("Error ScriptTrigger: Selection of %s in %s failed.\n",functionName.c_str(), script->getFileName().c_str());
     if( !(script->executeFunction()) )
       printf("Error ScriptTrigger: Execution of %s in %s failed.\n",functionName.c_str(), script->getFileName().c_str());
     }
}


void ScriptTrigger::setScript(const std::string& file)
{
  ScriptManager* scriptManager = State::getScriptManager();
  if (scriptManager != NULL)
  {
    script = scriptManager->getScriptByFile(file);
    if(script != NULL)
      scriptIsOk = true;
  }
}


 void ScriptTrigger::testScriptingFramework()
 {
   std::string file("lunartest2.lua");
     // Script script;
   Script* script = State::getScriptManager()->getScriptByFile(file);
   printf("-------------------------- top of the stack:%i\n",lua_gettop(script->getLuaState()));

      // Register classes with the script
      // Lunar<Account>::Register(&script);
      //Lunar<Object>::Register(&script);

      //Object* obj= new Object();
      //Account a;
      //Account *b = new Account(30);

      // Add instances to the script
      //Lunar<Object>::insertObject(&script,obj,"Obj",true);
      //Lunar<Account>::insertObject(&script,&a,"a",false);
      //Lunar<Account>::insertObject(&script,b,"b",true);
       //printf("-------------------------- top of the stack:%i\n",lua_gettop(script.getLuaState()));

      //Load a file
      //std::string file("lunartest2.lua");

      //if(script.loadFile(file))
        //printf("File %s succefully loaded\n", file.c_str());
      //printf("-------------------------- top of the stack:%i\n",lua_gettop(script.getLuaState()));

      //execute a function
   printf("----------- main -----------\n");
   std::string main("main");
   if( script->selectFunction(main,3))
     printf("function %s selected\n",main.c_str());

   script->pushParam(3.14159,main);
   script->executeFunction();

   float retf = script->getReturnedFloat();
   printf("main returned %f\n",retf);


   if(script->getReturnedBool())
     printf("main returned true\n");
   else
     printf("main returned false\n");

   int ret = script->getReturnedInt();
   printf("main returned %i\n",ret);

      //printf("-------------------------- top of the stack:%i\n",lua_gettop(script.getLuaState()));
      //execute a 2nd function
   printf("----------- test -----------\n");
   std::string test("test");
   if( script->selectFunction(test,0))
     printf("function %s selected\n",test.c_str());

   script->executeFunction();


      //if(argc>1) lua_dofile(script.getLuaState(), argv[1]);
   printf("-------------------------- top of the stack:%i\n",lua_gettop(script->getLuaState()));

 }
