/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_SHELL

#include "shell_completion_plugin.h"
#include "shell_command_class.h"

#include "shell_command.h"

#include "substring.h"
#include "class_list.h"
#include "loading/resource_manager.h"

#include "directory.h"
#include "debug.h"

namespace OrxShell
{
  CompletorDefault::CompletorDefault(const MultiType* value)
      :_value(value)
  { }

  void CompletorDefault::addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin) const
  {
    PRINT(0)("Requires '%s'\n", MultiType::MultiTypeToString(this->_value->getType()).c_str());
  }

  CompletorPlugin* CompletorDefault::clone() const
  {
    return new CompletorDefault(this->_value);
  }





  void CompletorStringArray::addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin) const
  {
    printf("TEST\n");
    unsigned int inputLen = completionBegin.size();
    for (unsigned int i = 0; i < this->_size; ++i)
    {
      printf("%s\n", this->_stringArray[i].c_str());
      if (!nocaseCmp(this->_stringArray[i], completionBegin, inputLen))
        completionList.push_back(this->_stringArray[i]);
    }
  }

  CompletorPlugin* CompletorStringArray::clone() const
  {
    return new CompletorStringArray(this->_stringArray, this->_size);
  }


  CompletorList::CompletorList(const std::list<std::string>* list)
  {
    this->_list = list;
  }

  void CompletorList::addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin) const
  {
    unsigned int inputLen = completionBegin.size();
    std::list<std::string>::const_iterator it;
    for (it = this->_list->begin(); it != this->_list->end(); ++it)
      if (!nocaseCmp((*it), completionBegin, inputLen))
        completionList.push_back(*it);
  }

  CompletorPlugin* CompletorList::clone() const
  {
    return new CompletorList(this->_list);
  }


  CompletorFileSystem::CompletorFileSystem(const std::string& fileExtension,
      const std::string& subDir)
      : _fileExtension(fileExtension), _subDir(subDir)
  {  }


  void CompletorFileSystem::addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin) const
  {
    Directory dir;

    if (completionBegin.empty()) // if we do not yet have the beginning of the line, start with the chosen startDir.
    {
      dir.setFileName(ResourceManager::getInstance()->getDataDir() + this->_subDir);
      dir.open();
      for(unsigned int i = 0; i < dir.fileCount(); i++ )
      {
        completionList.push_back(this->_subDir + "/" + dir[i]);
      }
    }
    else
    {
      bool grabbedDir = false;
      std::string directoryName;
      std::string::size_type pos = completionBegin.find_last_of("/");
      if (pos != std::string::npos)
        directoryName = completionBegin.substr(0, pos);

      dir.setFileName(ResourceManager::getInstance()->getDataDir() + directoryName);
      dir.open();

      std::string fileName;
      std::string currFile;
      for(unsigned int i = 0; i < dir.fileCount(); i++)
      {
        currFile = dir[i];
        if (currFile[0] == '.')
         continue;

        if (directoryName.empty())
          fileName = currFile;
        else
          fileName = directoryName + '/' + currFile;

        if (!nocaseCmp(completionBegin, fileName, completionBegin.size())  &&
             (this->_fileExtension.empty() || fileName.find(this->_fileExtension) != std::string::npos))
        {
          printf ("File %s\n", fileName.c_str());
          completionList.push_back(fileName);
          continue;
        }
        printf("%s\n", (ResourceManager::getInstance()->getDataDir() + fileName).c_str());
        if (!nocaseCmp(completionBegin, fileName, completionBegin.size()) &&
             ResourceManager::isInDataDir(fileName))
        {
          printf("Dir %s\n", fileName.c_str());
          grabbedDir = true;
          completionList.push_back(fileName + "/");
        }
      }

      if (completionList.size() == 1 && grabbedDir)
      {
        std::string dir = completionList[0];
        completionList.clear();
        this->addToCompleteList(completionList, dir);
      }
    }
  }

  CompletorPlugin* CompletorFileSystem::clone() const
  {
    return new CompletorFileSystem(this->_fileExtension, this->_subDir);
  }


}

