/*!
 * @file glgui_style.h
 * @brief Definition of the OpenGL-GUI Style of a Class.
*/

#ifndef _GLGUI_STYLE_H
#define _GLGUI_STYLE_H

// FORWARD DECLARATION

#include "font.h"
#include "texture.h"
#include "color.h"

namespace OrxGui
{
  //! A class for Defining Styles to the opengl-gui.
  class GLGuiStyle
  {
  public:

    //! Where a Certain feature will be positioned at.
    typedef enum {
      FeatureLeft,          //!< On the Left side.
      FeatureRight,         //!< On the Right side.
      FeatureTop,           //!< On Top of the rest of the Widget.
      FeatureBottom,        //!< At the Bottom of the rest of the Widget.
    } FeaturePosition;



  public:
    GLGuiStyle();
    virtual ~GLGuiStyle();

  private:
    float             _borderLeft;           //!< The Distance to the left Border of the widget, before any internal Element starts.
    float             _borderRight;          //!< The Distance to the right Border of the widget, before any internal Element starts.
    float             _borderTop;            //!< The Distance to the top Border of the widget, before any internal Element starts
    float             _borderBottom;         //!< The Distance to the bottom Border of the widget, before any internal Element starts

    Font*             _font;                 //!< The Font used in the current Widget.
    float             _textSize;             //!< The TextSize of the Widget.
    float             _textColor;            //!< The TextColor of the Widget.

    float             _backgroundColor;      //!< The BackgroundColor of the Widget.
    Texture           _backgorundTexture;    //!< The BackgroundTexture of the Widget.

    float             _foregroundColor;      //!< The foregroundColor of the Widget.
    Texture           _foregorundTexture;    //!< The ForegroundTexture of the Widget

    FeaturePosition   _featurePosition;      //!< The Position a Feature will be layed at (checkbox(box), slider(text),...)

    bool              _animated;             //!< If the Widget is animated (Texture might be an AnimatedTexture.)
    bool              _animatedStateChanges; //!< If the Transitions between States are Animated automatically.
  };
}
#endif /* _GLGUI_STYLE_H */
