/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION_REACTION

#include "collision.h"
#include "collision_event.h"

#include "physics_interface.h"

#include "world_entity.h"
#include "cr_physics_ground_walk.h"

using namespace std;


/**
 *  standard constructor
 */
CRPhysicsGroundWalk::CRPhysicsGroundWalk ()
  : CollisionReaction()
{
  this->setClassID(CL_CR_PHYSICS_GROUND_WALK, "CRPhysicsGroundWalk");
}


/**
 *  standard deconstructor
 */
CRPhysicsGroundWalk::~CRPhysicsGroundWalk ()
{
}


/**
 * caluculates and applys the reaction to a specific collision
 *  @param collision the collision
 */
void CRPhysicsGroundWalk::reactToCollision(Collision* collision)
{
//   Vector normal = collision
  PRINTF(0)("Ground\n");
}



/**
 * use this to do some collision offline calculations, only called for bContinuousPoll == true
 */
void CRPhysicsGroundWalk::update(WorldEntity* owner)
{
  this->lastPosition = owner->getAbsCoor();
  this->lastDirection = owner->getAbsDir();


}


