/**
* @file snow_effect.h
*/

#ifndef _SNOW_EFFECT
#define _SNOW_EFFECT

#include "vector.h"
#include "particle_system.h"
#include "material.h"
#include "vector2D.h"

#include "weather_effect.h"

class SpriteParticles;
class PlaneEmitter;
class PNode;

#include "sound_source.h"
#include "sound_buffer.h"

class SnowEffect : public WeatherEffect
{
	public:
		SnowEffect(const TiXmlElement* root = NULL);
		virtual ~SnowEffect();

		virtual void loadParams(const TiXmlElement* root);

		virtual bool init();

		virtual bool activate();
		virtual bool deactivate();

		inline void activateSnow() { this->activate(); }
		inline void deactivateSnow() { this->deactivate(); }
		
		virtual void draw() const;
		virtual void tick(float dt);


		inline void numParticles(int n) { this->particles = n; }
		inline void materialTexture(const std::string& texture) { this->texture = texture; }
		inline void lifeSpan(float lifeSpan, float randomLifeSpan) { this->life = lifeSpan; this->randomLife = randomLifeSpan; }
		inline void radius(float radius, float randomRadius) { this->snowRadius = radius; this->randomRadius = randomRadius; }
		inline void mass(float mass, float randomMass) { this->snowMass = mass; this->randomMass = randomMass; }
		inline void emissionRate(float emissionRate){ this->rate = emissionRate; }
		inline void emissionVelocity(float velocity, float randomVelocity){ this->velocity = velocity; this->randomVelocity = randomVelocity; }
		inline void size(float sizeX, float sizeY) { this->snowSize = Vector2D(sizeX, sizeY); }
		inline void coord(float x, float y, float z) { this->snowCoord = Vector(x, y, z); }
		inline void wind(int force) { this->snowWindForce = force; }

		inline void setSnowOption(const std::string& option) {
			/*if (option == "fade") this->snowFade = true;*/
			if (option == "movesnow") this->snowMove = true;
			if (option == "activate") this->snowActivate = true;
		}


	private:
		int 				particles;
		std::string 			texture;
		float				life, randomLife;
		float				snowRadius, randomRadius;
		float				snowMass, randomMass;
		float 				rate;
		float 				velocity, randomVelocity;
		float 				angle, randomAngle;
		float 				alpha;
		Vector 				snowCoord;
		Vector2D 			snowSize;
		int				snowWindForce;

		bool 				snowMove;
		bool 				snowActivate;

		PlaneEmitter*			emitter;

		static SpriteParticles*		snowParticles;
		OrxSound::SoundSource		soundSource;
		OrxSound::SoundBuffer*		windBuffer;

};


#endif  /* _SNOW_EFFECT */
