/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: hdavid, amaechler
*/

#include "lightening_effect.h"

#include "state.h"
#include "util/loading/load_param.h"
#include "util/loading/factory.h"
#include "effects/billboard.h"

#include "glincl.h"
#include "parser/tinyxml/tinyxml.h"

#include "shell_command.h"
#include "light.h"

SHELL_COMMAND(activate, LighteningEffect, activateLightening);
SHELL_COMMAND(deactivate, LighteningEffect, deactivateLightening);

using namespace std;

CREATE_FACTORY(LighteningEffect, CL_LIGHTENING_EFFECT);

LighteningEffect::LighteningEffect(const TiXmlElement* root)
{
	this->setClassID(CL_LIGHTENING_EFFECT, "LighteningEffect");
  
	this->init();

	if (root != NULL)
		this->loadParams(root);

  if(this->lighteningActivate)
	 this->activate();
}

LighteningEffect::~LighteningEffect()
{
	this->deactivate();
}

void LighteningEffect::loadParams(const TiXmlElement* root)
{
	WeatherEffect::loadParams(root);
  
  LoadParam(root, "coord", this, LighteningEffect, coord);
  LoadParam(root, "option", this, LighteningEffect, setLighteningOption);
  LoadParam(root, "frequency", this, LighteningEffect, setFlashFrequency);
  LoadParam(root, "const-time", this, LighteningEffect, setFlashConstTime);
  LoadParam(root, "rising-time", this, LighteningEffect, setFlashRisingTime);
  LoadParam(root, "size", this, LighteningEffect, setFlashSize);
  LoadParam(root, "seed", this, LighteningEffect, setFlashSeed);
}


bool LighteningEffect::init()
{
  lighteningActivate = false;
  
  this->time = 0.0;
  this->flashFrequency = 1.4f;
  this->flashConstTime = 0.5f;
  this->flashRisingTime = 0.1f;

  this->width = 400.0f;
  this->height = 100.0f;
  this->seedWidth = 50;
  this->seedHeight = 50;
  this->bNewCoordinate = false;

  this->seedX = 500.f;
  this->seedZ = 1000.0f;
  this->seedTime = 4.0f;

  this->billboard[0] = new Billboard(NULL);
  this->billboard[0]->setTexture("maps/lightning_bolt1.png");
  this->billboard[0]->setSize(this->width, this->height);
  this->billboard[0]->setAbsCoor(3000,850,0);
  this->billboard[0]->setVisibiliy(false);

  this->billboard[1] = new Billboard(NULL);
  this->billboard[1]->setTexture("maps/lightning_bolt2.png");
  this->billboard[1]->setSize(this->width, this->height);
  this->billboard[1]->setAbsCoor(3000,850,0);
  this->billboard[1]->setVisibiliy(false);

  this->billboard[2] = new Billboard(NULL);
  this->billboard[2]->setTexture("maps/lightning_bolt3.png");
  this->billboard[2]->setSize(this->width, this->height);
  this->billboard[2]->setAbsCoor(3000,850,0);
  this->billboard[2]->setVisibiliy(false);

  this->billboard[3] = new Billboard(NULL);
  this->billboard[3]->setTexture("maps/lightning_bolt4.png");
  this->billboard[3]->setSize(this->width, this->height);
  this->billboard[3]->setAbsCoor(0.0f, 50.0f, 0.0f);
  this->billboard[3]->setVisibiliy(false);
/*
  this->soundSource = NULL;
  this->thunderBuffer = NULL;

  this->soundSource.setSourceNode(this);

  //load sound
  if (this->thunderBuffer != NULL)
    ResourceManager::getInstance()->unload(this->thunderBuffer);
  this->thunderBuffer = (OrxSound::SoundBuffer*)ResourceManager::getInstance()->load("sound/thunder.wav", WAV);*/
}

void LighteningEffect::coord(float x, float y, float z)
{
  this->billboard[0]->setAbsCoor(x, y, z);
  this->billboard[1]->setAbsCoor(x, y, z);
  this->billboard[2]->setAbsCoor(x, y, z);
  this->billboard[3]->setAbsCoor(x, y, z);
  this->mainPosX = x;
  this->mainPosY = y;
  this->mainPosZ = z;
}


void LighteningEffect::setFlashSize(float width, float height, float seedWidth, float seedHeight)
{
  this->width = width;
  this->height = height;
  this->seedWidth = seedWidth;
  this->seedHeight = seedHeight;
  this->billboard[0]->setSize(this->width, this->height);
  this->billboard[1]->setSize(this->width, this->height);
  this->billboard[2]->setSize(this->width, this->height);
  this->billboard[3]->setSize(this->width, this->height);
}


bool LighteningEffect::activate()
{
	PRINTF(0)( "Activating LighteningEffect\n" );
  this->time = 0;
  lighteningActivate = true;
}


bool LighteningEffect::deactivate()
{
	PRINTF(0)("Deactivating LighteningEffect\n");
  this->billboard[0]->setVisibiliy(false);
  this->billboard[1]->setVisibiliy(false);
  this->billboard[2]->setVisibiliy(false);
  this->billboard[3]->setVisibiliy(false);
  lighteningActivate = false;
}

void LighteningEffect::tick (float dt)
{
  if(!lighteningActivate)
    return;
  
  this->time += dt;

  /*if( flashLight != NULL)
  {
    if((int)(100*time)%2)
      this->flashLight->setDiffuseColor(0,0,0);
    else
      this->flashLight->setDiffuseColor(100,100,100);
    
    //PRINTF(0)("100*time: %f %i\n", 100*time, (int)(100*time));
}*/
  
  if( this->time > this->flashFrequency)
  {
    this->billboard[0]->setVisibiliy(true);
    this->time = 0.0f;
    
    this->flashLight = new Light();
    this->flashLight->setAbsCoor(this->billboard[0]->getAbsCoor().x, this->billboard[0]->getAbsCoor().y, this->billboard[0]->getAbsCoor().z);
    this->flashLight->setDiffuseColor(100,100,100);
    
    //this->soundSource.play(this->thunderBuffer);
  }
  else if( this->billboard[3]->isVisible() && this->time > this->flashConstTime)
  {
    this->billboard[3]->setVisibiliy(false);
    this->time = 0.0f;
    this->bNewCoordinate = true;
    
    if(flashLight != NULL)
    {
      delete this->flashLight;
      flashLight = NULL;
    }
  }

  if( this->billboard[2]->isVisible() && this->time > this->flashRisingTime)
  {
    this->billboard[2]->setVisibiliy(false);
    this->billboard[3]->setVisibiliy(true);
    this->flashLight->setDiffuseColor(100,100,100);
  }
  else if( this->billboard[1]->isVisible() && this->time > this->flashRisingTime*2/3 )
  {
    this->billboard[1]->setVisibiliy(false);
    this->billboard[2]->setVisibiliy(true);
    this->flashLight->setDiffuseColor(0,0,0);
  }
  else if( this->billboard[0]->isVisible() && this->time > this->flashRisingTime*1/3 )
  {
    this->billboard[0]->setVisibiliy(false);
    this->billboard[1]->setVisibiliy(true);
    this->flashLight->setDiffuseColor(100,100,100);
  }

  if( this->bNewCoordinate)
  {
    float posX = this->mainPosX - this->seedX * (float)rand()/(float)RAND_MAX;
    float posZ = this->mainPosZ + this->seedZ * (float)rand()/(float)RAND_MAX;
    this->billboard[0]->setAbsCoor(posX, this->mainPosY, posZ);
    this->billboard[1]->setAbsCoor(posX, this->mainPosY, posZ);
    this->billboard[2]->setAbsCoor(posX, this->mainPosY, posZ);
    this->billboard[3]->setAbsCoor(posX, this->mainPosY, posZ);
    this->bNewCoordinate = false;
  }
}

void LighteningEffect::draw() const
{
}
