/*
	orxonox - the future of 3D-vertical-scrollers

	Copyright (C) 2004 orx

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

### File Specific:
	main-programmer: hdavid, amaechler

	INSPIRED BY http://www.codesampler.com/usersrc/usersrc_6.htm#oglu_sky_dome_shader
*/

#include "cloud_effect.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"
#include "util/loading/resource_manager.h"

#include "glincl.h"
#include "material.h"
#include <math.h>
#include "state.h"
#include "p_node.h"
#include "shader.h"
#include "shell_command.h"

#include "parser/tinyxml/tinyxml.h"

#include "sglmodel.h"

using namespace std;

SHELL_COMMAND(activate, CloudEffect, activateCloud);
SHELL_COMMAND(deactivate, CloudEffect, deactivateCloud);

CREATE_FACTORY(CloudEffect, CL_CLOUD_EFFECT);

CloudEffect::CloudEffect(const TiXmlElement* root)
{
	this->setClassID(CL_CLOUD_EFFECT, "CloudEffect");

	this->init();

	if (root != NULL)
		this->loadParams(root);

	if(cloudActivate)
		this->activate();
}

CloudEffect::~CloudEffect()
{
	this->deactivate();

	delete this->cloudMaterial;

	cloudModel.Delete();
	Shader::unload(this->cloudShader);

}


bool CloudEffect::init()
{
	PRINTF(1)("Initializing CloudEffect\n");

	// Default values
	this->cloudActivate = false;
	this->cloudTint[4] = ( 0.9f, 0.7f, 0.7f, 1.0f );
	this->cloudScroll = 1.0f;
	this->time = 0.0f;
	//g_cloud_texture = 0;

	this->cloudTexture = "pictures/sky/cloud1.jpg";

	cloudModel.Load("sky.sgl");
	cloudModel.Unitize();

	// Get the bounding box of the sky dome
	float bbox[3] = {0};
	cloudModel.GetDimensions(bbox[0], bbox[1], bbox[2]);
	
	// Load Shaders
	this->cloudShader = new Shader( ResourceManager::getInstance()->getDataDir() + "/shaders/sky.vert", ResourceManager::getInstance()->getDataDir() +"/shaders/sky.frag");

	// Tell the shader the bounding box of the sky dome
	this->cloudShader->bindShader("bbox", bbox, 4);

	// Initialze Cloud Material
	this->cloudMaterial = new Material("Sky");
	this->cloudMaterial->setIllum(3);
	this->cloudMaterial->setAmbient(1.0, 1.0, 1.0);
	this->cloudMaterial->setDiffuseMap(this->cloudTexture);

}


void CloudEffect::loadParams(const TiXmlElement* root)
{
	WeatherEffect::loadParams(root);

	// LoadParam(root, "speed", this, CloudEffect, setCloudAnimation);
	// LoadParam(root, "texture", this, CloudEffect, setCloudTexture);

	LOAD_PARAM_START_CYCLE(root, element);
	{
		LoadParam_CYCLE(element, "option", this, CloudEffect, setCloudOption);
	}
	LOAD_PARAM_END_CYCLE(element);
}


bool CloudEffect::activate()
{
	PRINTF(0)( "Activating CloudEffect with Material %s\n", this->cloudTexture.c_str());

	this->cloudActivate = true;
	
}

bool CloudEffect::deactivate()
{
	PRINTF(0)("Deactivating CloudEffect\n");

	this->cloudActivate = false;
}

void CloudEffect::draw() const
{
	if (!this->cloudActivate)
		return;
		
	// 	glMatrixMode(GL_MODELVIEW);
	// 	glPushMatrix();
	//
	// 	// Move sphere along with the camera
	// 	Vector r = State::getCameraNode()->getAbsCoor();
	// 	glTranslatef(r.x, r.y, r.z);
	//
	// 	// Sky movement
	// 	glRotatef(mover, 0, 0, 1);
	//
	// 	cloudMaterial->select();
	// 	gluSphere(this->sphereObj, this->sphereRadius, 20, 20);
	// 	glPopMatrix();

	// ******

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();

	// glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	// glShadeModel(GL_SMOOTH);
	// glEnable(GL_DEPTH_TEST);
	// glEnable(GL_CULL_FACE);
	// glCullFace(GL_BACK);
	// glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	
	// glLineWidth(3.0f);

	static float time = 0.0f;
	// static vector3f eye = {0.0f, 0.0f, 0.0f}, look = {0.0f, 0.0f, 1.0f}, up = {0.0f, 1.0f, 0.0f};

	// glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	// glLoadIdentity();
	// gluLookAt(eye[x], eye[y], eye[z], look[x], look[y], look[z], up[x], up[y], up[z]);

	// Turn off the depth buffer when rendering the background
	// glDisable(GL_DEPTH_TEST);

	this->cloudShader->activateShader();

	/* Select the shader program and update parameters. */
	/* The "time" parameter controls the cloud scrolling. */
	this->cloudShader->bindShader("time", &time, 1);
	/* The "horizon" parameter controls the sky tinting. */
	this->cloudShader->bindShader("horizon", cloudTint, 4);

	glActiveTexture(GL_TEXTURE0 + 0);
	glActiveTexture(GL_TEXTURE0 + 1);

	// Load the cloud texture
	//glBindTexture(GL_TEXTURE_2D, g_cloud_texture);
	this->cloudMaterial->select();

	// Render the sky dome
	cloudModel.Render();

	// Unselect the shader
	Shader::deactivateShader();

	/* Turn on the depth buffer when rendering the foreground. */
	// glEnable(GL_DEPTH_TEST);

	/* Render the forground, for example, a teapot or bunny. */
	//    glEnable(GL_LIGHTING);
	//    glColor3f(0.0f, 1.0f, 0.0f);
	//    glBegin(GL_QUADS);
	//    glNormal3f( 0.0f,  1.0f,  0.0f);
	//    glVertex3f( 20.0f, -1.0f,  20.0f);
	//    glVertex3f( 20.0f, -1.0f, -20.0f);
	//    glVertex3f(-20.0f, -1.0f, -20.0f);
	//    glVertex3f(-20.0f, -1.0f,  20.0f);
	//    glEnd();
	//    glDisable(GL_LIGHTING);

	glPopMatrix();
	
}

void CloudEffect::tick (float dt)
{
	if (!this->cloudActivate)
		return;

	// Update the timer for scrolling the clouds
	time = time + ((1.0f / 2000.0f) * cloudScroll);
}

