
#include <iostream>

#include "luaincl.h"




class Object : public BaseObject {
   public:
     static const char className[];
     static Lunar<Object>::RegType methods[];

     Object(lua_State* L) {callCount = 0; }
     Object(){callCount = 0;};
     ~Object() { printf("deleted Object (%p)\n", this); }

        //meber functions
     void takeParam(int i)
     {
       printf("Lua passed %i to c++\n",i);
     }

     int printName(lua_State* L)
     {
       this->printName();
       return 0;
     }

     void printName()
     {
       callCount ++;
       printf("Hi i'm object %p ! This is the %i. call.\n",this,callCount);
     }

     int getCallCount(){ return callCount; }

   private:
     int callCount;

 };

 const char Object::className[] = "Object";

 Lunar<Object>::RegType Object::methods[] = {
   {"printName", new ExecutorLua0<Object>(&Object::printName)},
   {"getCallCount", new ExecutorLua0ret<Object, int>(&Object::getCallCount)},
   {"takeParam", new ExecutorLua1<Object, int>(&Object::takeParam)},
   {0,0}
 };
 
CREATE_SCRIPTABLE_CLASS(Object, CL_TEST_OBJECT)