 
 
 
#include <iostream>

#include "luaincl.h"


 
 class Account : public BaseObject {
      lua_Number m_balance;
   public:
     static const char className[];
     static Lunar<Account>::RegType methods[];

     Account(lua_State *L)      { m_balance = luaL_checknumber(L, 1); }
     Account(double balance=0)    : m_balance(balance) { }

     void deposit (float value) { m_balance += value; };
     void withdraw(float value) { m_balance -= value; };
     float balance() { return m_balance; };

     int deposit (lua_State *L) { m_balance += luaL_checknumber(L, 1); return 0; }
     int withdraw(lua_State *L) { m_balance -= luaL_checknumber(L, 1); return 0; }
     int balance (lua_State *L) { lua_pushnumber(L, m_balance); return 1; }
     ~Account() { printf("deleted Account (%p)\n", this); }
 };

 const char Account::className[] = "Account";

 Lunar<Account>::RegType Account::methods[] = {
   {"deposit", new ExecutorLua1<Account, float>(&Account::deposit)},
   {"withdraw", new ExecutorLua1<Account, float>(&Account::withdraw)},
   {"balance", new ExecutorLua0ret<Account, float>(&Account::balance)},
   {0,NULL}
 };
 
CREATE_SCRIPTABLE_CLASS(Account, CL_ACCOUNT)