#ifndef _SCRIPT_MANAGER_H
#define _SCRIPT_MANAGER_H

#include <list>

#include "base_object.h"
#include "script.h"


class ScriptTrigger;
class Scriptable;

class ScriptManager : public BaseObject
{
 public:
   ScriptManager(const TiXmlElement* root = NULL);
   ~ScriptManager();

  /// LOADING
  virtual void loadParams(const TiXmlElement* root);

  /// QUERRYING
  Script* getScriptByFile(const std::string& file);



 private:
   void  flush();                                   //!< Resets the script manager
   void  createScripts(const TiXmlElement* scripts);
   void  createTriggers(const TiXmlElement* triggers);

   bool getTriggers();
   bool getScripts();

   static ScriptManager*             singletonRef;   //!< Reference to this class

   const std::list<BaseObject*>*     triggers;       //!< A list of all the triggers in the world

   const std::list<BaseObject*>*     scripts;        //!< A list of all the scripts in the world


};
#endif
