/*!
 * @file executor.h
 * Definition of a on-screen-shell
 */

#ifndef _EXECUTOR_LUA_H
#define _EXECUTOR_LUA_H

#include "executor.h"
#include "compiler.h"
#include "debug.h"
#include "luaincl.h"



template<typename type> type fromLua(lua_State* state, int index) { PRINTF(1)("NOT IMPLEMENTED\n"); };
template<> bool fromLua<bool>(lua_State* state, int index);
template<> int fromLua<int>(lua_State* state, int index);
template<> unsigned int fromLua<unsigned int>(lua_State* state, int index);
template<> float fromLua<float>(lua_State* state, int index);
template<> char fromLua<char>(lua_State* state, int index);
template<> const std::string& fromLua<const std::string&>(lua_State* state, int index);


template<typename type> void toLua(lua_State* state, type value) { PRINTF(1)("NOT IMPLEMENTED\n"); };
template<> void toLua<bool>(lua_State* state, bool value);
template<> void toLua<int>(lua_State* state, int value);
template<> void toLua<unsigned int>(lua_State* state, unsigned int value);
template<> void toLua<float>(lua_State* state, float value);
template<> void toLua<char>(lua_State* state, char value);
template<> void toLua<const std::string&>(lua_State* state, const std::string& value);

// FORWARD DECLARATION

///////////////////////
///// WITHOUT RET /////
///////////////////////

///////////
//// 0 ////
///////////
//! Executes a Function with a lua_State* parameter.
template<class T> class ExecutorLua0 : public Executor
{
  public:
    /**
     * @brief Constructor of a ExecutorXML
     * @param function a Function to call
     */
    ExecutorLua0(void(T::*function)())
        : Executor()
    {
      this->functionPointer = function;
      this->functorType = Executor_Objective | Executor_NoLoadString;
    }

    /**
     * @brief executes the Command on BaseObject
     * @param object the BaseObject to execute this Executor on
     * @param loadString ignored in this case
     */
    virtual void operator()(BaseObject* object, const SubString& = SubString()) const
    {
      PRINTF(1)("no usefull executor\n");
    }

    virtual void operator()(BaseObject* object, int& count, void* values) const
    {
      (dynamic_cast<T*>(object)->*(functionPointer))();
      count = 0;
    }

    /**
     * @returns a _new_ Copy of this Executor
     */
    virtual Executor* clone () const
    {
      return new ExecutorLua0<T>(ExecutorLua0<T>(this->functionPointer));
    }
  private:
    void          (T::*functionPointer)();
};



///////////
//// 1 ////
///////////
//! Executes a Function with a lua_State* parameter.
template<class T, typename type0> class ExecutorLua1 : public Executor
{
  public:
    /**
     * @brief Constructor of a ExecutorXML
     * @param function a Function to call
     */
    ExecutorLua1(void(T::*function)(type0))
        : Executor(ExecutorParamType<type0>())
    {
      this->functionPointer = function;
      this->functorType = Executor_Objective | Executor_NoLoadString;
    }

    /**
       * @brief executes the Command on BaseObject
       * @param object the BaseObject to execute this Executor on
       * @param loadString ignored in this case
     */
    virtual void operator()(BaseObject* object, const SubString& = SubString()) const
    {
      PRINTF(1)("no usefull executor\n");
    }

    virtual void operator()(BaseObject* object, int& count, void* values) const
    {
      lua_State* state = (lua_State*)values;
      count = 0;

      (dynamic_cast<T*>(object)->*(functionPointer))(fromLua<type0>(state, 1));
    }

    /**
       * @returns a _new_ Copy of this Executor
     */
    virtual Executor* clone () const
    {
      return new ExecutorLua1<T, type0>((this->functionPointer));
    }
  private:
    void          (T::*functionPointer)(type0);
};



///////////
//// 2 ////
///////////
//! Executes a Function with a lua_State* parameter.
template<class T, typename type0, typename type1> class ExecutorLua2 : public Executor
{
  public:
    /**
     * @brief Constructor of a ExecutorXML
     * @param function a Function to call
     */
    ExecutorLua2(void(T::*function)(type0, type1))
        : Executor(ExecutorParamType<type0>(), ExecutorParamType<type1>())
    {
      this->functionPointer = function;
      this->functorType = Executor_Objective | Executor_NoLoadString;
    }

    /**
     * @brief executes the Command on BaseObject
     * @param object the BaseObject to execute this Executor on
     * @param loadString ignored in this case
     */
    virtual void operator()(BaseObject* object, const SubString& = SubString()) const
    {
      PRINTF(1)("no usefull executor\n");
    }

    virtual void operator()(BaseObject* object, int& count, void* values) const
    {
      lua_State* state = (lua_State*)values;
      count = 0;

      (dynamic_cast<T*>(object)->*(functionPointer))(
        fromLua<type0>(state, 1),
        fromLua<type1>(state, 2) );
    }

    /**
     * @returns a _new_ Copy of this Executor
     */
    virtual Executor* clone () const
    {
      return new ExecutorLua2<T, type0, type1>(this->functionPointer);
    }
  private:
    void          (T::*functionPointer)(type0, type1);
};







////////////////////
///// WITH RET /////
////////////////////


///////////
//// 0 ////
///////////
//! Executes a Function with a lua_State* parameter.
template<class T, typename ret> class ExecutorLua0ret : public Executor
{
  public:
    /**
     * @brief Constructor of a ExecutorXML
     * @param function a Function to call
     */
    ExecutorLua0ret(ret (T::*function)())
        : Executor()
    {
      this->functionPointer = function;
      this->functorType = Executor_Objective | Executor_NoLoadString;
    }

    /**
     * @brief executes the Command on BaseObject
     * @param object the BaseObject to execute this Executor on
     * @param loadString ignored in this case
     */
    virtual void operator()(BaseObject* object, const SubString& = SubString()) const
    {
      PRINTF(1)("no usefull executor\n");
    }

    virtual void operator()(BaseObject* object, int& count, void* values) const
    {
      lua_State* state = (lua_State*)values;
      count = 1;

      toLua<ret>(state, (dynamic_cast<T*>(object)->*(functionPointer))());
    }

    /**
                       * @returns a _new_ Copy of this Executor
     */
    virtual Executor* clone () const
    {
      return new ExecutorLua0ret<T, ret>(this->functionPointer);
    }
  private:
    ret           (T::*functionPointer)();
};



///////////
//// 1 ////
///////////
//! Executes a Function with a lua_State* parameter.
template<class T, typename ret, typename type0> class ExecutorLua1ret : public Executor
{
  public:
    /**
     * @brief Constructor of a ExecutorXML
     * @param function a Function to call
     */
    ExecutorLua1ret(ret (T::*function)(type0))
        : Executor(ExecutorParamType<type0>())
    {
      this->functionPointer = function;
      this->functorType = Executor_Objective | Executor_NoLoadString;
    }

    /**
     * @brief executes the Command on BaseObject
     * @param object the BaseObject to execute this Executor on
     * @param loadString ignored in this case
     */
    virtual void operator()(BaseObject* object, const SubString& = SubString()) const
    {
      PRINTF(1)("no usefull executor\n");
    }

    virtual void operator()(BaseObject* object, int& count, void* values) const
    {
      lua_State* state = (lua_State*)values;
      count = 1;

      toLua<ret>(state, (dynamic_cast<T*>(object)->*(functionPointer))(
                   fromLua<type0>(state, 1)));
    }

    /**
     * @returns a _new_ Copy of this Executor
     */
    virtual Executor* clone () const
    {
      return new ExecutorLua1ret<T, ret, type0>(this->functionPointer);
    }
  private:
    ret           (T::*functionPointer)(type0);
};

///////////
//// 2 ////
///////////
//! Executes a Function with a lua_State* parameter.
template<class T, typename ret, typename type0, typename type1> class ExecutorLua2ret : public Executor
{
  public:
    /**
     * @brief Constructor of a ExecutorXML
     * @param function a Function to call
     */
    ExecutorLua2ret(ret (T::*function)(type0, type1))
        : Executor(ExecutorParamType<type0>(), ExecutorParamType<type1>())
    {
      this->functionPointer = function;
      this->functorType = Executor_Objective | Executor_NoLoadString;
    }

    /**
     * @brief executes the Command on BaseObject
     * @param object the BaseObject to execute this Executor on
     * @param loadString ignored in this case
     */
    virtual void operator()(BaseObject* object, const SubString& = SubString()) const
    {
      PRINTF(1)("no usefull executor\n");
    }

    virtual void operator()(BaseObject* object, int& count, void* values) const
    {
      lua_State* state = (lua_State*)values;
      count = 1;

      toLua<ret>(state, (dynamic_cast<T*>(object)->*(functionPointer))(
                   fromLua<type0>(state, 1),
                   fromLua<type1>(state, 2) ));
    }

    /**
     * @returns a _new_ Copy of this Executor
     */
    virtual Executor* clone () const
    {
      return new ExecutorLua2ret<T, ret, type0, type1>(this->functionPointer);
    }
  private:
    ret           (T::*functionPointer)(type0, type1);
};







#endif /* _EXECUTOR_LUA_H */
