#ifndef _SCRIPT_TRIGGER_H
#define _SCRIPT_TRIGGER_H

#include <string>

#include "world_entity.h"
#include "loading/load_param.h"
#include "vector.h"
#include "script_manager.h"

class ScriptTrigger : public WorldEntity
{
  public:
    ScriptTrigger(const TiXmlElement* root = NULL);
    ~ScriptTrigger();

    ///LOADING
    virtual void loadParams(const TiXmlElement* root);
    
    
    /// DO WORK
    virtual void tick(float timestep);
    virtual void executeAction();

    /// SET MEMBER
    void setTarget(const std::string& targetName);
    void setTarget(WorldEntity* target) { if(target!=NULL) this->target=target; }
    void setTriggerParent(const std::string& name);
    void setCallOnce(const bool call) { this->callOnce = call; }
    void setRadius(const float radius) { if(radius>0) this->radius = radius; }
    void setDelay(const float time){if(delay>0) this->delay = delay; }
    void setScript(const std::string& script){ this->scriptFile = script; }
    void setFunction(const std::string& function){ this->functionName = function; }


  private:

    WorldEntity* target;
    bool         callOnce;
    float        radius;
    float        delay;
    std::string  scriptFile;
    std::string  functionName;

    //for internal use
    bool         scriptCalled;
    bool         callScript;
    bool         triggered;
    float        timer;

};

#endif
