#include "script_trigger.h"
#include "class_list.h"
#include "script.h"


ScriptTrigger::ScriptTrigger(const TiXmlElement* root)
{
  scriptCalled = false;
  callScript = false;
  triggered = false;
  loadParams(root);


}

ScriptTrigger::~ScriptTrigger()
{

}

void ScriptTrigger::loadParams(const TiXmlElement* root)
{
  if(root != NULL)
  {
  WorldEntity ::loadParams(root);
  
   { LoadParam(root, "file", this, ScriptTrigger, setScript)
        .describe("the fileName of the script, that should be triggered by this script trigger")
        .defaultValues("");
    LoadParam(root, "function", this, ScriptTrigger, setFunction)
        .describe("the function of the script, that should be triggered by this script trigger")
        .defaultValues("");
    LoadParam(root, "abs-coor", this, ScriptTrigger, setAbsCoor)
        .describe("where this script trigger should be located")
        .defaultValues("");
    LoadParam(root, "radius", this, ScriptTrigger, setRadius)
        .describe("the fileName of the script, that should be triggered by this script trigger")
        .defaultValues(0);
    LoadParam(root, "delay", this, ScriptTrigger, setDelay)
        .describe("the delay after which the funtion sould be triggered")
        .defaultValues(0);
    LoadParam(root, "worldentity", this, ScriptTrigger, setTarget)
        .describe("The name of the target as it is in the *.oxw file")
        .defaultValues("");
    LoadParam(root, "triggerparent", this, ScriptTrigger, setTriggerParent)
        .describe("The name of the target as it is in the *.oxw file")
        .defaultValues("");

    }
    timer = delay;
  }
 
}


void ScriptTrigger::setTarget(const std::string& target)
{
  BaseObject* targetEntity = ClassList::getObject(target, CL_WORLD_ENTITY);
  
  if (targetEntity != NULL)
  {
    this->setTarget(dynamic_cast<WorldEntity*>(targetEntity));
  }
  else
  {
    PRINTF(2)("Target %s for %s::%s does not Exist\n", target.c_str(), this->getClassName(), this->getName());
  }
}

void ScriptTrigger::setTriggerParent(const std::string& parent)
{
  BaseObject* parentEntity = ClassList::getObject(parent, CL_WORLD_ENTITY);
  
  if (parentEntity != NULL)
  {
    this->setParent(dynamic_cast<WorldEntity*>(parentEntity));
    this->setParentMode(PNODE_MOVEMENT);
  }
  else
  {
    PRINTF(2)("Parent %s for %s::%s does not Exist\n", parent.c_str(), this->getClassName(), this->getName());
  }
}

void ScriptTrigger::tick(float timestep)
{

 if((this->getAbsDirV()-target->getAbsDirV()).len() < radius)
 {
  if(!callOnce)
   {
    executeAction();
   }
  else if(callOnce && !scriptCalled)
  {
   executeAction();
   scriptCalled = true;
  }
 }

}



void ScriptTrigger::executeAction()
{
     ScriptManager* scriptManager = ScriptManager::getInstance();
     Script* script = scriptManager->getScriptByFile(this->scriptFile);
     if(script != NULL)
     {
     if(!(script->selectFunction(this->functionName,0)) )
       printf("Error ScriptTrigger: Selection of %s in %s failed.\n",functionName.c_str(), scriptFile.c_str());
     if( !(script->executeFunction()) )
       printf("Error ScriptTrigger: Execution of %s in %s failed.\n",functionName.c_str(),scriptFile.c_str());
     }
}
