#ifndef _SCRIPT_MANAGER_H
#define _SCRIPT_MANAGER_H

#include <list>

#include "base_object.h"
#include "script.h"


class ScriptTrigger;
class Scriptable;

class ScriptManager : public BaseObject
{
 public:
   ScriptManager();
   ~ScriptManager();

  inline static ScriptManager* getInstance() { if (!ScriptManager::singletonRef)ScriptManager::singletonRef = new ScriptManager(); return ScriptManager::singletonRef; }

  virtual void loadParams(const TiXmlElement* root);

  Script* getScriptByFile(std::string& file);


  
 private:

   void  init();
   void  createScripts(const TiXmlElement* scripts);
   void  createTriggers(const TiXmlElement* triggers);
   
   bool getTriggers();
   bool getScripts();

   static ScriptManager*             singletonRef;   //!< Reference to this class

   const std::list<BaseObject*>*     triggers;

   const std::list<BaseObject*>*     scripts;


};
#endif
