#include <string>
#include <list>


#include "script_manager.h"
#include "lunar.h"

#include "class_list.h"

#include "script.h"
#include "script_trigger.h"
#include "luaincl.h"
#include "loading/load_param.h"
#include "parser/tinyxml/tinyxml.h"



ScriptManager::ScriptManager()
{
  this->init();
}

ScriptManager::~ScriptManager()
{


}


void ScriptManager::loadParams(const TiXmlElement* root)
{
  //BaseObject::loadParams(root);

  LoadParamXML(root, "ScriptTriggers", this, ScriptManager, createTriggers); 
  
  LoadParamXML(root, "Scripts", this, ScriptManager, createScripts);
}


void ScriptManager::init()
{
  //this->setClassID("");
  this->setName("ScriptManager");
  
  this->scripts = NULL;
  this->triggers = NULL;
}


void  ScriptManager::createScripts(const TiXmlElement* scripts)
{
  
  LOAD_PARAM_START_CYCLE(scripts, object);
  {
    new Script(object);
  }
  LOAD_PARAM_END_CYCLE(object);

}

void ScriptManager::createTriggers(const TiXmlElement* triggers)
{
  LOAD_PARAM_START_CYCLE(triggers, object);
  {
    new ScriptTrigger(object);
  }
  LOAD_PARAM_END_CYCLE(object);

}


Script* ScriptManager::getScriptByFile(std::string& file)
{

//   for(std::list<LuaScript>::iterator it = scriptList.begin(); it != scriptList.end(); it++ )
//   {
//     if( (*it).name.compare(file) == 0)
//     {
//       return &((*it).script);
//     }
//   }
//   return NULL;

}


bool ScriptManager::getScripts()
{
  return (this->scripts != NULL || (this->scripts = ClassList::getList(CL_SCRIPT)) != NULL); 
}



