#ifndef _SCRIPT_H
#define _SCRIPT_H


#include "base_object.h"

struct lua_State;

class Script : public BaseObject
{
  public:
    Script(const TiXmlElement* root = NULL);
    ~Script();
    
    /// LOADING
    void loadParams(const TiXmlElement* root);

    void loadFileNoRet(const std::string& filename) { loadFile(filename); };
    bool loadFile(const std::string& filename);
    /** @returns fileName */
    std::string getFileName() { return currentFile; }

    void addObject(const std::string& className, const std::string& objectName);
    
        

    lua_State* getLuaState() const { return luaState; }


    
    /// EXECUTING
    // first select function
    bool selectFunction(std::string& functionName, int retCount);

    // push parameters for luafunction
    bool  pushParam(int param, std::string& toFunction);
    bool  pushParam(float param, std::string& toFunction);
    bool  pushParam(double param, std::string& toFunction);

    // Execute the Function
    bool executeFunction();
    
     // get returned values the last return value in lua is the first in c. TODO: change order of return
    int   getReturnedInt();
    bool  getReturnedBool();
    float getReturnedFloat();
    void  getReturnedString(std::string& string);

    bool executeFile();

  private:

    int reportError(int error);          //!< Get errormessage from the lua stack and print it.

    lua_State*         luaState;         //!< The lua_State that the Script works on
    std::string        currentFile;      //!< The file that is loaded in the script
    std::string        currentFunction;  //!< The name of the current active function (the one that gets the pushed parameter)
    int                argumentCount;    //!< Number of arguments for the current function
    int                returnCount;      //!< Number of return values of the current function



};
#endif /* _SCRIPT_H */
