#ifndef _SCRIPT_TRIGGER_H
#define _SCRIPT_TRIGGER_H

#include <string>

#include "world_entity.h"
#include "loading/load_param.h"
#include "vector.h"
#include "script_manager.h"

class ScriptTrigger : public WorldEntity
{
  public:
    ScriptTrigger();
    ~ScriptTrigger();

    virtual void loadParams(const TiXmlElement* root);
    virtual void tick(float timestep);
    virtual void executeAction();

    
    void setTarget(const std::string& targetName);
    
    void setTarget(WorldEntity* target) { if(target!=NULL) this->target=target;if(worldEntityIsParent)this->setParent(target); }
    void setTargetName(std::string& name){ this->targetName = name; }
    void setCallOnce(bool call) { this->callOnce = call;}
    void setRadius(float radius) { if(radius>0) this->radius = radius;}
    void setDelay(float time){if(delay>0) this->delay = delay;}
    void setScript(std::string& script){this->scriptFile = script;}
    void setFunction(std::string& function){this->functionName = function;}

    std::string getTargetName(){return targetName;}

  private:

    std::string  parentName;
    WorldEntity* target;
    std::string  targetName;
    bool         worldEntityIsParent;
    bool         callOnce;
    bool scriptCalled;
    float radius;
    float delay;
    std::string scriptFile;
    std::string functionName;

    bool callScript;
    bool triggered;
    float timer;

};

#endif
