/*!
 * @file scriptable.h
 * @brief Definition of ...
*/

#ifndef _SCRIPTABLE_H
#define _SCRIPTABLE_H

#include "base_object.h"

#include "script.h"
#include "lunar.h"

// FORWARD DECLARATION


/**
 * Creates a factory to a Loadable Class.
 * this should be used at the beginning of all the Classes that should be loadable (in the cc-file)
 */
#define CREATE_SCRIPTABLE_CLASS(CLASS_NAME, CLASS_ID) \
    tScriptable<CLASS_NAME> global_##CLASS_NAME##_ScriptableClass(#CLASS_NAME, CLASS_ID)



//! A class for ...
class Scriptable : protected BaseObject
{

public:
  Scriptable(const std::string& name, ClassID classID);
  virtual ~Scriptable();

  bool operator==(const std::string& name) { return (this->getName() == name); }
  bool operator==(ClassID classID) { return (this->classID == classID); }
  
  virtual void registerClass(Script* script) = 0;
  virtual int insertObject(Script* L, BaseObject* obj, const std::string& name, bool gc=false) = 0;

private:
  ClassID             classID;
};




template <class T>
class tScriptable : public Scriptable
{
  tScriptable(const std::string& name, ClassID classID)
  : Scriptable(name, classID)
  { }

  virtual void registerClass(Script* script)
  {
    Lunar<T>::Register(script);
  }
  virtual int insertObject(Script* L, BaseObject* obj, bool gc=false) 
  {
    Lunar<T>::insertObject(L, dynamic_cast<T*>(obj), obj->getName(), gc);
  }
  


}
;


#endif /* _SCRIPTABLE_H */
