/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Andreas Maechler, David Hasenfratz
   co-programmer: ...
*/

#include "atmospheric_engine.h"

#include "util/loading/resource_manager.h"

#include "effects/fog_effect.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"
#include "class_list.h"


using namespace std;

/**
 * @param root The XML-element to load the AtmosphericEngine from
 */
AtmosphericEngine::AtmosphericEngine()
{
  this->setClassID(CL_ATMOSPHERIC_ENGINE, "AtmosphericEngine");
}

/**
 *  The Pointer to this AtmosphericEngine
*/
AtmosphericEngine* AtmosphericEngine::singletonRef = NULL;


/**
 *  destroys a AtmosphericEngine
 */
AtmosphericEngine::~AtmosphericEngine()
{
  AtmosphericEngine::singletonRef = NULL;

  const std::list<BaseObject*>* weatherEffects = ClassList::getList( CL_WEATHER_EFFECT);

  if (weatherEffects != NULL)
  {
      while(!weatherEffects->empty())
        delete weatherEffects->front();
  }
}

/**
 * @param root The XML-element to load the AtmosphericEngine from
 */
void AtmosphericEngine::loadParams(const TiXmlElement* root)
{
  LoadParamXML(root, "WeatherEffect", this, AtmosphericEngine, loadWeatherEffect);
  LoadParamXML(root, "SunEffect", this, AtmosphericEngine, loadSunEffect);
}

/**
 * @param root The XML-element to load WeatherEffects from
 */
void AtmosphericEngine::loadWeatherEffect(const TiXmlElement* root)
{
  LOAD_PARAM_START_CYCLE(root, element);
  {
    PRINTF(4)("element is: %s\n", element->Value());
    // Factory::fabricate(element);

    BaseObject* bo = Factory::fabricate(element);
    if( bo == NULL)
      PRINTF(0)(" Could not create Element %s\n", element->Value());
  }
  LOAD_PARAM_END_CYCLE(element);
}

/**
 * @param root The XML-element to load SunEffects from
 */
void AtmosphericEngine::loadSunEffect(const TiXmlElement* root)
{
  LOAD_PARAM_START_CYCLE(root, element);
  {
    PRINTF(4)("element is: %s\n", element->Value());
  }
  LOAD_PARAM_END_CYCLE(element);
}


/**
 * draws the effect, if needed
 */
void AtmosphericEngine::draw() const
{
  const std::list<BaseObject*>* weatherEffects = ClassList::getList( CL_WEATHER_EFFECT);

  // draw the weather effects
  if (weatherEffects != NULL)
  {
    std::list<BaseObject*>::const_iterator it;
    for (it = weatherEffects->begin(); it != weatherEffects->end(); it++)
      dynamic_cast<WeatherEffect*>(*it)->draw();
  }
}



/**
 * ticks the effect if there is any time dependancy
 */
void AtmosphericEngine::tick(float dt)
{
  const std::list<BaseObject*>* weatherEffects = ClassList::getList( CL_WEATHER_EFFECT);

  // tick the weather effects
  if (weatherEffects != NULL)
  {
    std::list<BaseObject*>::const_iterator it;
    for (it = weatherEffects->begin(); it != weatherEffects->end(); it++)
    {
/*      printf("%s::%s \n", (*it)->getClassName(), (*it)->getName());*/
      dynamic_cast<WeatherEffect*>(*it)->tick(dt);
    }
  }
}
