/*!
 * @file collision_event.h
 *  Definition of a collision event
 */

#ifndef _COLLISION_EVENT_H
#define _COLLISION_EVENT_H

#include "vector.h"

class WorldEntity;
class BoundingVolume;
class Plane;


//! A class representing a simple collision
class CollisionEvent {

 public:
   CollisionEvent();
  virtual ~CollisionEvent();

  /** collides two WorldEntities @param entityA world entity A, @param entityB world entity B, @param bvA volume A @param bvB volumeB */
  inline void collide(WorldEntity* entityA, WorldEntity* entityB, BoundingVolume* bvA, BoundingVolume* bvB)
  { this->entityA = entityA; this->entityB = entityB; this->bvA = bvA; this->bvB = bvB; }
  /** collides two WorldEntities @param entity world entity , @param ground ground plane, @param position position on the ground */
  inline void collide(WorldEntity* entity, Plane* ground, Vector position)
  { this->entityA = entity; this->ground = ground; this->position = position; }


  /** @return CollisionEvent WorldEntity A */
  inline WorldEntity* getEntityA() const { return this->entityA; }
  /** @return CollisionEvent WorldEntity B */
  inline WorldEntity* getEntityB() const { return this->entityB; }
  /** @return Bounding Volume from EntityA */
  inline BoundingVolume* getBVA() const { return this->bvA; }
  /** @return Bounding Volume from EntityB */
  inline BoundingVolume* getBVB() const { return this->bvB; }


  inline void operator()(WorldEntity* entityA, WorldEntity* entityB, BoundingVolume* bvA, BoundingVolume* bvB) { this->collide(entityA, entityB, bvA, bvB); }
  inline void operator()(WorldEntity* entity, Plane* ground, Vector position) { this->collide(entity, ground, position); }


 private:
  WorldEntity*      entityA;                       //!< the collision body A
  WorldEntity*      entityB;                       //!< the collision body B

  BoundingVolume*   bvA;                           //!< reference to the bounding volume A
  BoundingVolume*   bvB;                           //!< reference to the bounding volume B

  Plane*            ground;                        //!< the ground plane with which it collides (only for bsp-model collisions
  Vector            position;                      //!< position of the collision on the ground plane
};

#endif /* _COLLISION_EVENT_H */
