/*
   orxonox - the future of 3D-vertical-scrollers
 
   Copyright (C) 2006 orx
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   ### File Specific:
   main-programmer: bottac@ee.ethz.ch
   
   Inspired by:
   Rendering Q3 Maps by Morgan McGuire                  http://graphics.cs.brown.edu/games/quake/quake3.html
   Unofficial Quake 3 Map Specs by Kekoa Proudfoot      http://graphics.stanford.edu/~kekoa/q3/
   
   Collision detection adapted from:
   Quake 3 Collision Detection by Nathan Ostgard        http://www.devmaster.net/articles/quake3collision/
*/

#include <vector>
#include <deque>

// FORWARD DECLARATIONS
class  BspFile;
class BspTreeLeaf;
class BspTreeNode;
class Vector;
class set;
struct face;
struct brush;
struct plane;

class WorldEntity;

struct BspCollisionEvent
{
  Vector normal; //!< normal Vector, length 1
  Vector place;  //!< Absoloute coordinates of collision
};

class BspManager
{
public:
  // Constructors
  BspManager();
  
  BspManager(const char* fileName, float scale = 0.4f);
  void load(const char* fileName, float scale);

  // Functions
  const void draw();
  void draw_debug_face(int Face); 
  void draw_face(int Face);
  void draw_patch(face* Face);
  

  void checkCollision(WorldEntity* worldEntity);

private:
  // Functions
  BspTreeNode* getLeaf(BspTreeNode*  node,   Vector* cam) ;  //!< Traverses the tree
  void  checkCollision(BspTreeNode* node, Vector* cam);
  void  checkCollisionRay(BspTreeNode * node,float startFraction, float endFraction, Vector* start, Vector* end); 
  void  checkCollisionRayN(BspTreeNode * node,float startFraction, float endFraction, Vector* start, Vector* end); 
  void  checkBrushRay(brush* curBrush);
  void  checkBrushRayN(brush* curBrush);
  void drawDebugCube(Vector* cam);
  bool isAlreadyVisible(int Face);
  void addFace(int Face);
  
  // Data
  BspFile*  bspFile;
  BspTreeNode* root;
  Vector cam;
  Vector ship;
  Vector  viewDir;
  plane* collPlane;
  int lastTex;
  
  //obsolete
  bool  outputStartsOut;
  bool  outputAllSolid;
  float outputFraction;
  
  bool * alreadyVisible;
  // Deques to store the visible faces
  ::std::deque<int> trasparent; //!< the ones with transparancy go here
  ::std::deque<int> opal; //!< the others here.

  Vector out;
  Vector out1;
  Vector out2;
};

