#ifndef _SCRIPT_MANAGER_H
#define _SCRIPT_MNAGER_H

#include <list>
#include <string>

#include "script.h"
#include "base_object.h"
#include "luaincl.h"
#include "loading/load_param.h"


//!< Contains the name of a lua script file  and a list of all objects that the script needs
struct LuaScript
{
  std::string name;
  std::list<std::string> objectList;
  Script script;
};

class ScriptManager //: public BaseObject
{
 public:
   ScriptManager();
   ~ScriptManager();

  inline static ScriptManager* getInstance();

  virtual void loadParams(const TiXmlElement* root);
  void setWorld(std::string& world){currentWorld = world;}

  void tick(float timestep);

  void initScripts(); // initializes all scripts

 private:

   void  init();
   void  createScriptList(const TiXmlElement* scripts);
   void  setCurrentScriptFile(std::string& file);
   void  addObjectToScript(std::string& object, LuaScript& script);

   bool fileIsInScriptList(std::string& file);
   bool objectIsInObjectList(std::string& object,const LuaScript& script);


   static ScriptManager*      singletonRef;   //!< Reference to this class
   std::list<LuaScript>       scriptList;     //!< The list of all scripts that the current world needs
   std::string                currentWorld;
   LuaScript                  currentScript;  //!< For temorary use



};
#endif
