#include <string>
#include <list>

#include "script.h"
#include "script_manager.h"
#include "lunar.h"


ScriptManager::ScriptManager()
{
  this->init();
}

ScriptManager::~ScriptManager()
{


}

ScriptManager* ScriptManager::getInstance()
{

  if (!ScriptManager::singletonRef)
    ScriptManager::singletonRef = new ScriptManager();
  return ScriptManager::singletonRef;

}

void ScriptManager::loadParams(const TiXmlElement* root)
{
  //BaseObject::loadParams(root);

  const TiXmlElement* scripts = root->FirstChildElement("Scripts");

  if( scripts == NULL)
  {
    PRINTF(1)("ScriptManager is missing 'Scripts'\n");
  }
  else
  {
    createScriptList(scripts);
  }


}

void ScriptManager::tick(float timestep)
{
}


void ScriptManager::initScripts()
{
  for(std::list<LuaScript>::iterator it = scriptList.begin(); it != scriptList.end(); it++ )
  {
    (*it).script.loadFile((*it).name);
  }
}

void ScriptManager::init()
{
  currentWorld.assign("");

}


void  ScriptManager::createScriptList(const TiXmlElement* scripts)
{
  const TiXmlElement* script = scripts->FirstChildElement();
  const TiXmlElement* object;

  PRINTF(4)("Creating scriptlist\n");

  while( script != NULL)
  {
    LoadParam(script, "file", this, ScriptManager, setCurrentScriptFile)
        .describe("the fileName of the script, that should be loaded into this world")
        .defaultValues("");

    if(!currentScript.name.empty()) // if LoadParam didn't fail... fill the object list with the needed objects
    {
    object = script->FirstChildElement("object");

    while(object != NULL)
    {
      addObjectToScript(object->Value(), currentScript);
      object = object->NextSiblingElement("object");
    }

    scriptList.push_back(currentScript);
    }

    script = script->NextSiblingElement("Script");

  }


}

void  ScriptManager::setCurrentScriptFile(std::string& file)
 {
   if( !fileIsInScriptList(file) )
     currentScript.name = file;
   else
     currentScript.name.assign("");
 }

void  ScriptManager::addObjectToScript(std::string& object, LuaScript& script)
{
  if(!objectIsInObjectList(object,script))
    script.objectList.push_back(object);
}


bool ScriptManager::fileIsInScriptList(std::string& file)
{
  for(std::list<LuaScript>::const_iterator it = scriptList.begin(); it != scriptList.end(); it++ )
  {
    if( (*it).name.compare(file) == 0)
    {
      return true;
    }
  }
  return false;
}


bool ScriptManager::objectIsInObjectList(std::string& object, const LuaScript& script)
{
  for(std::list<std::string>::const_iterator it = script.objectList.begin(); it != script.objectList.end(); it++ )
  {
    if( (*it).compare(object) == 0)
    {
      return true;
    }
  }
  return false;
}


