/*!
 * @file color.h
 * @brief Definition of color-calculations
 *
 * code borrowed from:
 * http://www.easyrgb.com/math.php
*/

#ifndef _COLOR_H
#define _COLOR_H

#include "vector.h"

//! a very abstract Class that helps transforming Colors into different Systems
class Color
{
public:
  Color(float r, float g, float b, float a) :_r(r), _g(g), _b(b), _a(a) {};
  Color(const Color& c) { _r = c._r; _g = c._g; _b = c._b; _a = c._a; };

  float r() const { return _r; }
  float& r() { return _r; }
  float g() const { return _g; }
  float& g() { return _g; }
  float b() const { return _b; }
  float& b() { return _b; }
  float a() const { return _a; }
  float& a() { return _a; }

public:
  static Vector RGBtoHSV (const Vector& RGB);
  static void RGBtoHSV (const Vector& RGB, Vector& HSV);
  static Vector HSVtoRGB (const Vector& HSV);
  static void HSVtoRGB (const Vector& HSV, Vector& RGB);

private:
  static float minrgb(float r, float g, float b);
  static float maxrgb(float r, float g, float b);

  float       _r;     //!< Red Value.
  float       _g;     //!< Green Value.
  float       _b;     //!< Blue Value.
  float       _a;     //!< Alpha Value.

};

#endif /* _COLOR_H */
