/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "qt_gui_elements.h"

namespace OrxGui
{



  QtGuiCheckBox::QtGuiCheckBox(const std::string& name, SaveableGroup* group, bool defaultValue)
  : QCheckBox(QString().fromStdString(name)), Saveable(name, group, defaultValue)
  {
    //this->load(this->value());
  }

  void QtGuiCheckBox::load()
  {
    Saveable::load();
    if (this->value().getBool())
      this->setCheckState(Qt::Checked);
    else
      this->setCheckState(Qt::Unchecked);
  }



  void QtGuiCheckBox::save()
  {
    this->value() = this->checkState();
    Saveable::save();
  }





  QtGuiSlider::QtGuiSlider(const std::string& name, SaveableGroup* group, int defaultValue, Qt::Orientation orientation)
  : QSlider(orientation), Saveable(name, group, defaultValue)
  {

  }

  QtGuiSlider::~QtGuiSlider()
  {}

  void QtGuiSlider::load()
  {
    Saveable::load();
    this->setValue(this->Saveable::value().getInt());
  }

  void QtGuiSlider::save()
  {
    this->Saveable::value() = this->QSlider::value();
    Saveable::save();
  }







  QtGuiComboBox::QtGuiComboBox(const std::string& name, SaveableGroup* group, const std::string& defaultValue)
  : QComboBox(), Saveable(name, group, defaultValue)
  {


  }

  void QtGuiComboBox::load()
  {
    Saveable::load();
    int index = this->findText(QString().fromStdString(this->value().getString()));
    if (index == -1)
      index = 1;
    this->setCurrentIndex(index);
  }

  void QtGuiComboBox::save()
  {
    this->value() = this->currentText().toStdString();
    Saveable::save();
  }


  QtGuiInputLine::QtGuiInputLine(const std::string& name, SaveableGroup* group, const std::string& defaultValue)
  : QLineEdit(), Saveable(name, group, defaultValue)
  {


  }


  void QtGuiInputLine::load()
  {
    Saveable::load();
    this->setText(QString().fromStdString(this->value().getString()));
  }



  void QtGuiInputLine::save()
  {
    this->value() = this->text().toStdString();
    Saveable::save();
  }




}
