/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "gui_video.h"

#include <QtGui/QLayout>
#include "globals.h"
#include "debug.h"

#include "qt_gui_elements.h"

namespace OrxGui
{
  /**
   *  Creates the Video-Option-Frame
  */
  GuiVideo::GuiVideo(OrxGui::Gui* gui)
  : Element(CONFIG_SECTION_VIDEO, gui), QGroupBox()
  {
    QGridLayout* layout = new QGridLayout(this);

    {
      QtGuiCheckBox* fullscreen = new QtGuiCheckBox(CONFIG_NAME_FULLSCREEN, this, false);
      //fullscreen->setName();
      layout->addWidget(fullscreen, 0, 0);

      QtGuiCheckBox* wireframe = new QtGuiCheckBox(CONFIG_NAME_WIREFRAME, this, false);
      layout->addWidget(wireframe, 1, 0);

      {
        QComboBox* resolution = new QtGuiComboBox(CONFIG_NAME_RESOLUTION, this, "640x480");
        resolution->setEditable(true);
        layout->addWidget(resolution, 2, 0);
        std::vector<QString> resolutions;
        this->getResolutions(resolutions);
        for (unsigned int i = 0; i < resolutions.size(); ++i)
          resolution->addItem(resolutions[i]);
      }


      QGroupBox* advanced = new GuiAdvancedVideo(gui);


      layout->addWidget(advanced, 0, 2, 4, 1);

    }
  }

  /**
   *  Destructs the Video-stuff
  */
  GuiVideo::~GuiVideo()
  {
    // nothing to do here.
  }

  /**
   *  sets all resolutions to the menu
   * @param menu the Menu to set The resolutions to.
  */
  void GuiVideo::getResolutions(std::vector<QString>& resolutionList)
  {
    SDL_Init(SDL_INIT_VIDEO);
    SDL_Rect **modes;
    int i;
    int x = 0,y =0; // check for difference
    char tmpChar[100];

    /* Get available fullscreen/hardware modes */
    modes=SDL_ListModes(NULL, SDL_FULLSCREEN|SDL_HWSURFACE);

    /* Check is there are any modes available */
    if(modes == (SDL_Rect **)0)
    {
      PRINTF(2)("No video-modes available!\n");
      exit(-1);
    }

    /* Check if our resolution is restricted */
    if(modes == (SDL_Rect **)-1)
    {
      PRINTF(2)("All resolutions available.\n");
    }
    else
    {
      /* Print valid modes */
      PRINT(5)("Available Modes\n");
      for(i = 0; modes[i] ;++i)
      {
        if (x != modes[i]->w || y != modes[i]->h)
        {
          PRINTF(5)("  %d x %d\n", modes[i]->w, modes[i]->h);
          sprintf(tmpChar, "%dx%d", modes[i]->w, modes[i]->h);
          resolutionList.push_back(QString(tmpChar));
          x = modes[i]->w; y = modes[i]->h;
        }
      }
    }
    SDL_QuitSubSystem(SDL_INIT_VIDEO);
    SDL_Quit();
  }



  GuiAdvancedVideo::GuiAdvancedVideo(OrxGui::Gui* gui)
  : Element(CONFIG_SECTION_VIDEO_ADVANCED ,gui)
  {
    {
      QGridLayout* advLayout = new QGridLayout(this);              //!< Advanced Layout
      {
        QtGuiCheckBox* shadows = new QtGuiCheckBox(CONFIG_NAME_SHADOWS, this, true);         //!< CheckBox for shadows
        advLayout->addWidget(shadows, 0,0);
        QtGuiCheckBox* fog = new QtGuiCheckBox(CONFIG_NAME_FOG, this, true);                 //!< CheckBox for fog.
        advLayout->addWidget(fog, 1,0);
        QtGuiCheckBox* reflections = new QtGuiCheckBox(CONFIG_NAME_REFLECTIONS, this, true);  //!< CheckBox for reflections
        advLayout->addWidget(reflections, 2, 0);
        QtGuiCheckBox* textures = new QtGuiCheckBox(CONFIG_NAME_TEXTURES, this, true);       //!< CheckBox for textures
        advLayout->addWidget(textures, 3, 0);
          /*
        Menu* textureDetail;      //!< Menu for the Texture-Detail.
        Label* modelDetailLabel;  //!< Label for model-detail.
        Menu* modelDetail;        //!< model-detail.
        CheckBox* particles;   //!< If the Particles should be enabled
        Label* antiAliasingLabel; //!< Label for the anti-aliasing mode.
        Menu* antiAliasing;       //!< Menu for the Antialiasing-mode.
        Label* filterMethodLabel; //!< Label for filtering-Method.
        Menu* filterMethod;       //!< Menu for filtering Method.
        Button* closeButton;      //!< A Button to close the Advanced-settingsWindow.
          */
      }
    }
  }

  GuiAdvancedVideo::~GuiAdvancedVideo()
  {
  }

}
