/*!
  \file gui_general.h
  \brief File that holds the class that creates the General-Options.
*/
#ifndef _GUI_GENERAL_H
#define _GUI_GENERAL_H

#include "../gui_element.h"
#include <vector>
#include <string>
#include <QtGui/QGroupBox>


namespace OrxGui
{
  class QtGuiInputLine;

  //! Class that creates the Audio-Options.
  class GuiGeneral : public QGroupBox, public OrxGui::Element
  {
    Q_OBJECT

  public:
    GuiGeneral(OrxGui::Gui* gui);
    virtual ~GuiGeneral();

  public slots:
    void openDataFileDialog();

  private:
    QtGuiInputLine* dataDir;
  };
}

#endif /* _GUI_GENERAL_H */
