/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include "gui_banner.h"

#include "gui_gtk.h"

#include "banner.xpm"
#include "logo.xpm"

/**
 *  Creates a new BannerEventBox and its content.
*/
GuiBanner::GuiBanner()
{
  // the banner Frame
  Frame* bannerFrame;       //!< The frame that holds the Banner.
  Box* bannerBox;           //!< The box that holds the Banner.
  EventBox* bannerEventBox; //!< an Image needs an EventBox to catch klicks.
  Label* bannerLabel;       //!< The Label of the Banner.

  // the logo Window
  Window* logoWindow;       //!< The Window that holds the Orxonox-CrewLogo.
  Box* logoBox;             //!< The Box that holds the Orxonox-CrewLogo
  Image* logoImage;         //!< The Orxonox-CrewLogo-Image
  Label* logoLabel;         //!< The Label for the Orxonox-CrewLogo
  Label* orxIsLabel;        //!< Some text about us.


  // Banner Itself //
  bannerEventBox = new EventBox("BannerEventBox");
  {
    Image* bannerImage;       //!< The Image for the Banner.

    bannerImage = new Image(banner_xpm);
    bannerEventBox->fill(bannerImage);
  }
  // Banner Window //
  logoWindow = new Window(PACKAGE_NAME " is:");
  {
  EventBox* logoEventBox;   //!< The EventBox that holds the Orxonox-CrewLogo. it has to be an eventbox, because Images can not receive clicks.
  
#ifdef HAVE_GTK2
    bannerEventBox->connectSignal("button_press_event", logoWindow, Window::windowOpen);
    logoWindow->connectSignal("destroy", logoWindow, Window::windowClose);
    logoWindow->connectSignal("delete_event", logoWindow, Window::windowClose);
#endif /* HAVE_GTK2 */
    logoEventBox = new EventBox();
    logoBox = new Box('v');
    logoLabel = new Label(PACKAGE_NAME " v." PACKAGE_VERSION);
    logoBox->fill(logoLabel);
    logoImage = new Image(logo_xpm);
    logoBox->fill(logoImage);

    //! @todo add the names of all the guys working on orxonox
    orxIsLabel = new Label("           " PACKAGE_NAME " is:\n" ORXONOX_STAFF);
    logoBox->fill(orxIsLabel);
    logoEventBox->fill(logoBox);
#ifdef HAVE_GTK2
    logoEventBox->connectSignal("button_press_event", logoWindow, Window::windowClose);
#endif /* HAVE_GTK2 */
    logoWindow->fill(logoEventBox);
  }
  Window::addWindow(logoWindow);
  
  setMainWidget(bannerEventBox);
}

/**
 *  Destructs it.
*/
GuiBanner::~GuiBanner()
{
  // nothing to do here
}
