/*!
 * @file signal_connector.h
 * @brief Definition of a SignalConnector class
*/

#ifndef _SIGNAL_CONNECTOR_H
#define _SIGNAL_CONNECTOR_H

#include "executor/executor.h"

namespace OrxGui
{

  //////////////// TO BE IGNORED BY YOU /////
#define DeclareSignalBegin(SignalName) \
  public: \
   void signal_ ## connect ## SignalName(const SignalConnector& connector) { \
     SignalName ## connected.push_back(connector); \
}\
   Signal& getSignalVector_##SignalName () { return this->SignalName ## connected; }; \
  private:

#define DeclareSignalEnd(SignalName) \
  Signal SignalName ## connected
  /////////////////////////////////////////////


  /**
   * @brief declares a new Signal.
   * @param SignalName the Name of the Signal.
   */
#define DeclareSignal0(SignalName) \
  DeclareSignalBegin(SignalName) \
   void  SignalName () { \
     for (unsigned int i = 0; i < SignalName ## connected .size(); i++) \
       SignalName ## connected[i] (); \
   }\
     DeclareSignalEnd(SignalName)


  /**
   * @brief declares a new Signal.
   * @param SignalName the Name of the Signal.
   * @param param0 the first Parameter the Function takes
   */
#define DeclareSignal1(SignalName, param0) \
  DeclareSignalBegin(SignalName) \
   void  SignalName (param0 val0) { \
     for (unsigned int i = 0; i < SignalName ## connected .size(); i++) \
       SignalName ## connected[i] (val0); \
    }\
    DeclareSignalEnd(SignalName)

  /**
   * @brief declares a new Signal.
   * @param SignalName the Name of the Signal.
   * @param param0 the first Parameter the Function takes
   * @param param1 the second Parameter the Function takes
   */
#define DeclareSignal2(SignalName, param0, param1) \
  DeclareSignalBegin(SignalName) \
   void  SignalName (param0 val0, param1 val1) { \
     for (unsigned int i = 0; i < SignalName ## connected .size(); i++) \
       SignalName ## connected[i] (val0, val1); \
}\
    DeclareSignalEnd(SignalName)



  /**
   * @brief declares a new Signal.
   * @param SignalName the Name of the Signal.
   * @param param0 the first Parameter the Function takes
   * @param param1 the second Parameter the Function takes
   * @param param2 the third Parameter the Function takes
   */
#define DeclareSignal3(SignalName, param0, param1, param2) \
  DeclareSignalBegin(SignalName) \
   void  SignalName (param0 val0, param1 val1, param2 val2) { \
     for (unsigned int i = 0; i < SignalName ## connected .size(); i++) \
       SignalName ## connected[i] (val0, val1, val2); \
}\
    DeclareSignalEnd(SignalName)

  /**
   * @brief declares a new Signal.
   * @param SignalName the Name of the Signal.
   * @param param0 the first Parameter the Function takes
   * @param param1 the second Parameter the Function takes
   * @param param2 the third Parameter the Function takes
   * @param param3 the fourth Parameter the Function takes
   */
#define DeclareSignal4(SignalName, param0, param1, param2, param3) \
  DeclareSignalBegin(SignalName) \
   void  SignalName (param0 val0, param1 val1, param2 val2, param3 val3) { \
     for (unsigned int i = 0; i < SignalName ## connected .size(); i++) \
       SignalName ## connected[i] (val0, val1, val2, val3); \
}\
    DeclareSignalEnd(SignalName)


  /**
   * @brief declares a new Signal.
   * @param SignalName the Name of the Signal.
   * @param param0 the first Parameter the Function takes
   * @param param1 the second Parameter the Function takes
   * @param param2 the third Parameter the Function takes
   * @param param4 the fifth Parameter the Function takes
   */
#define DeclareSignal5(SignalName, param0, param1, param2, param3, param4) \
  DeclareSignalBegin(SignalName) \
   void  SignalName (param0 val0, param1 val1, param2 val2, param3 val3, param4 val4) { \
     for (unsigned int i = 0; i < SignalName ## connected .size(); i++) \
       SignalName ## connected[i] (val0, val1, val2, val3, val4); \
}\
    DeclareSignalEnd(SignalName)


  /**
   * @brief selects a Signal.
   * @param SignalName the Signal to be retrieved.
   */
#define SIGNAL(Object, SignalName) \
    Object->getSignalVector_##SignalName()

  /**
   * @brief defines a Slot, the sink of a Signal.
   * @param Class the Class the Slot belongs to.
   * @param function the Function to Connect to.
   */
#define SLOT(Class, function) \
    createExecutor<Class>(&Class::function)

  /**
   * @brief emits function
   */
#define emit(function) function

  //! A class for Conncting Signals to Objects, inside of the Graphical user interface.
  /**
   * The SignalConnector binds an Object to a Functional (Executor)
   * The Usage is quite easy in the Widget for this:
   *
   * int the header (Class Definition) you can add a definition of a Signal with:
   * @verbatim DeclareSignal3(my_signal, int, int, float)
   * and a Signal with the the Parameters int,int and float will be created.
   *
   * now you can use the connect function of GLWidget to connect this Signal to a Slot.
   * @see GLGuiWidget::connect
   */
  class SignalConnector
  {
  public:
    SignalConnector();
    SignalConnector(BaseObject* object, const Executor* exec);
    SignalConnector(const SignalConnector& signalConnector);
    ~SignalConnector();

    SignalConnector& operator=(const SignalConnector& signalConnector);
    bool operator==(const SignalConnector& signalConnector) const;

    void operator()() const;
    void operator()(const MultiType& value0) const;
    void operator()(const MultiType& value0, const MultiType& value1) const;
    void operator()(const MultiType& value0, const MultiType& value1, const MultiType& value2) const;
    void operator()(const MultiType& value0, const MultiType& value1, const MultiType& value2, const MultiType& value3) const;
    void operator()(const MultiType& value0, const MultiType& value1, const MultiType& value2, const MultiType& value3, const MultiType& value4) const;

    /** checks wether the SignalConnector is valid @return true on valid. */
    bool isValid() const { return (this->object && this->exec); };
    /** @brief checks if the SignalConnector is clean, invalid @returns true if invalid */
    bool isClean() const { return (this->object == NULL || this->exec == NULL); }


  private:
    BaseObject*          object;         //!< The object to call.
    const Executor*      exec;           //!< The Executor, that will be called, on object.
  };

  //! TypeDefinition for SignalLists
  typedef std::vector<SignalConnector> Signal;
  //! TypeDefinition for a Slot.
  typedef Executor*                    Slot;

}
#endif /* _SIGNAL_CONNECTOR_H */
