/*!
 * @file glmenu_imagescreen.h
 * class to display a LoadScreen
 */

#ifndef _GLMENU_IMAGESCREEN_H
#define _GLMENU_IMAGESCREEN_H

#include "base_object.h"

class Material;
class TiXmlElement;

//! A class to display a loadScreen
class GLMenuImageScreen : public BaseObject
{

public:
  GLMenuImageScreen (const TiXmlElement* root = NULL);
  virtual void loadParams(const TiXmlElement* root);
  virtual ~GLMenuImageScreen ();

  void draw();

  void setBackgroundImage(const std::string& backImageName);
  void setPosition(float offsetX, float offsetY);
  void setScale (float scaleX, float scaleY);
  void setPosScale(float offsetX, float offsetY, float scaleX, float scaleY);

  void setBarImage(const std::string& barImage);
  void setBarPosScale(float barX, float barY, float barW, float barH);

  void setMaximum (int maxValue);
  /** @returns the maximum of countable steps*/
  inline int GLMenuImageScreen::getMaximum() const { return this->maxValue; };

  void setValue (int currentValue);
  int  getValue ();
  void step ();


private:
  // background image
  std::string         backImageName;       //!< the name of the file of the background image
  float         offsetX;             //!< X-offset of the the image from the left
  float         offsetY;             //!< Y-offset of the image from the top
  float         scaleX;              //!< width of the image
  float         scaleY;              //!< height of the image
  Material*     backMat;             //!< Background Material.

  // Load-Bar
  float         barX;                //!< X-position of the Bar
  float         barY;                //!< Y-position of the Bar
  float         barW;                //!< Width of the Bat
  float         barH;                //!< Height of the Bar.
  Material*     barMat;              //!< A Material for the Loading-Bar

  /* progress bar values */
  int           currentValue;        //!< the current count of step() calls fired yet
  int           maxValue;            //!< total count of steps

};

#endif /* _GLMENU_IMAGESCREEN_H */
