/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_image.h"

namespace OrxGui
{

  /**
   * standard constructor
  */
  GLGuiImage::GLGuiImage ()
  {
    this->init();

  }


  /**
   * standard deconstructor
  */
  GLGuiImage::~GLGuiImage()
  {
  }

  /**
   * initializes the GUI-element
   */
  void GLGuiImage::init()
  {
    this->setClassID(CL_GLGUI_IMAGE, "GLGuiImage");

    this->frontMaterial().setDiffuseMap(this->texture);
    this->frontMaterial().setBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    this->resize();
  }


  void GLGuiImage::loadImageFromTexture(const Texture& texture)
  {
    this->frontMaterial().setDiffuseMap(texture);
    this->frontMaterial().setDiffuse(1,1,1);
  }

  void GLGuiImage::loadImageFromFile(const std::string& fileName)
  {
    this->texture.loadImage(fileName);
  }

  void GLGuiImage::loadImageFromSDLSurface(SDL_Surface* surface)
  {
    //this->texture.loadSurface(surface);
  }

  void GLGuiImage::loadImageFromDisplayList(GLuint texture)
  {
//    this->texture.setTexture(texture);
  }

  void GLGuiImage::resize()
  {
    this->frontRect().setTopLeft(this->borderLeft(), this->borderTop());
    this->frontRect().setSize(this->getSizeX2D() - (borderLeft() + borderRight()), this->getSizeY2D() - (borderTop() + borderBottom()) );
    GLGuiWidget::resize();
  }


  /**
   * @brief draws the GLGuiImage
   */
  void GLGuiImage::draw() const
  {
    this->beginDraw();
    GLGuiWidget::draw();

    this->frontMaterial().select();
    this->drawRect(this->frontRect());
    this->endDraw();
  }
}
