/*!
 * @file glgui_container.h
 * The gl_container widget of th openglGUI
 *
 */

#ifndef _GLGUI_CONTAINER_H
#define _GLGUI_CONTAINER_H

#include "glgui_widget.h"

namespace OrxGui
{
  // FORWARD DECLARATION

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiContainer : public GLGuiWidget
  {

  public:
    GLGuiContainer();
    virtual ~GLGuiContainer();

    /** @brief packs a widget into this one. */
    virtual void pack(GLGuiWidget* widget) = 0;
    /** unpacks a Widget from this container. @param widget the GLGuiWidget to unpack, if NULL all subwidgets will be unpackt. */
    virtual void unpack(GLGuiWidget* widget) = 0;
    /** @brief clears all Widgets out. */
    virtual void clear() = 0;

    virtual void hideAll() = 0;
    virtual void showAll() = 0;


    virtual void draw();

  private:
    void init();
  };
}
#endif /* _GLGUI__H */
