/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_box.h"

namespace OrxGui
{
  /**
   * standard constructor
  */
  GLGuiBox::GLGuiBox (OrxGui::Orientation orientation)
  {
    this->init();

    this->setOrientation(orientation);
  }


  /**
   * standard deconstructor
  */
  GLGuiBox::~GLGuiBox()
  {}

  /**
   * initializes the GUI-element
   */
  void GLGuiBox::init()
  {
    this->setClassID(CL_GLGUI_BOX, "GLGuiBox");
  }

  void GLGuiBox::pack(GLGuiWidget* widget)
  {
    assert (widget != NULL);

    this->children.push_back(widget);
    widget->setParentWidget(this);

    this->resize();
  }


  void GLGuiBox::unpack(GLGuiWidget* widget)
  {
    assert(widget == NULL);

    std::vector<GLGuiWidget*>::iterator delWidget = std::find(this->children.begin(), this->children.end(), widget);
    if (delWidget != this->children.end())
    {
      (*delWidget)->setParentWidget(NULL);
      this->children.erase(delWidget);
    }
    this->resize();
  }

  void GLGuiBox::clear()
  {
    this->children.clear();
    this->resize();
  }

  void GLGuiBox::showAll()
  {
    std::vector<GLGuiWidget*>::iterator itC = this->children.begin();
    while (itC != this->children.end())
    {
      if ((*itC)->isA(CL_GLGUI_CONTAINER))
        static_cast<GLGuiContainer*>(*itC)->showAll();
      else
        (*itC)->show();
      itC++;
    }

    this->show();
  }

  void GLGuiBox::hideAll()
  {
    std::vector<GLGuiWidget*>::iterator itC = this->children.begin();
    while (itC != this->children.end())
    {
      if ((*itC)->isA(CL_GLGUI_CONTAINER))
        static_cast<GLGuiContainer*>(*itC)->hideAll();
      else
        (*itC)->hide();
      itC++;
    }

    this->hide();
  }

  void GLGuiBox::resize()
  {
    if (orientation() == OrxGui::Vertical)
    {
      float height = this->borderTop();
      float width = 0.0f;
      std::vector<GLGuiWidget*>::iterator widget;

      // find out how big the Widgets are.
      for (widget = this->children.begin(); widget != this->children.end(); ++widget)
      {
        (*widget)->setRelCoor2D(this->borderLeft(), height);
        height += (*widget)->getSizeY2D();
        width = fmax(width, (*widget)->getSizeX2D());
      }

      width += this->borderLeft() + this->borderRight();
      height += this->borderBottom(); /* *2 done further up */

      printf("%f %f\n", width, height);
      this->setSize2D(width, height);
    }
    else
    {
      float height = this->borderTop();
      float width = this->borderLeft();
      std::vector<GLGuiWidget*>::iterator widget;

      // find out how big the Widgets are.
      for (widget = this->children.begin(); widget != this->children.end(); ++widget)
      {
        (*widget)->setRelCoor2D(width, this->borderTop());
        height = fmax(height, (*widget)->getSizeY2D());
        width += (*widget)->getSizeX2D();
      }

      width += this->borderRight() ;
      height += this->borderBottom(); /* *2 done further up */

      printf("%f %f\n", width, height);
      this->setSize2D(width, height);
    }
    GLGuiWidget::resize();

    // resize everything.
    //for (widget = this->children.begin(); widget != this->children.end(); ++widget)
    //{}
  }

  /**
   * @brief draws the GLGuiBox
   */
  void GLGuiBox::draw() const
  {
    this->beginDraw();
    GLGuiWidget::draw();
    this->endDraw();
  }
}
