/*!
 * @file glgui_bar.h
 * The gl_ widget of th openglGUI
 *
 */

#ifndef _GLGUI_BAR_H
#define _GLGUI_BAR_H

#include "glgui_widget.h"


namespace OrxGui
{


  //! This is Bar part of the openglGUI class
  /**
   * The Bar shows the part value.
   */
  class GLGuiBar : public GLGuiWidget
  {

  public:
    GLGuiBar();
    virtual ~GLGuiBar();

    void setValue(float value) { this->value = value; };
    void setMinimum(float minimum) { this->minimum = minimum; };
    void setMaximum(float maximum) { this->maximum = maximum; };

    float getValue() const { return this->value; };
    float getMinimum() const { return this->minimum; };
    float getMaximum() const { return this->maximum; };

    virtual void update() { };
    virtual void draw() const;

  private:
    void init();

  private:
    float value;

    float minimum;
    float maximum;
  };
}
#endif /* _GLGUI__H */
