/*!
  \file gui_flags.h
  \brief File that holds the class that creates the flags-Text.
*/

#ifndef _GUI_FLAGS_H
#define _GUI_FLAGS_H

#include "gui.h"
#include "gui_element.h"
#include "gui_gtk.h"

//! Class that creates the flags-Text.
class GuiFlags : public GuiElement
{
 private:
  Frame* flagsFrame;          //!< The Frame that holds the flagsDisplay.
  Box* flagsBox;              //!< The Box that holds the flagsDisplay.
  CheckButton* shortFlags;    //!< CheckButton to change the display of short and long flags @todo show long if long not availible...
  Label* flagsLabel;          //!< The Label of the Flags

 public:
  GuiFlags();
  virtual ~GuiFlags();

  void setTextFromFlags(Widget* widget);
  static void flagsText(Widget* widget, void* flagInfo);

  //! Struct that handles flag information.
  struct FlagInfo
  {
    CheckButton* shortFlags;     //!< Button for the flag.
    Label* flagsLabel;           //!< Label for the flag.
  };
};
#endif /* _GUI_FLAGS_H */
