/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include "gui_audio.h"

#include "gui_gtk.h"

/**
 *  Creates an Audio-Frame
*/
GuiAudio::GuiAudio()
{
  Frame* audioFrame;        //!< The Frame that holds the audio Options.

  audioFrame = new Frame("Audio-Options:");
  audioFrame->setGroupName(CONFIG_SECTION_AUDIO);
  {
    Box* audioBox;            //!< The Box that holds the audio Options.
    audioBox = new Box('v');
    {
      CheckButton* enableSound; //!< A Ckeckbutton for enabling Sound.
      Slider* audioChannels;    //!< A Slider for the count of audio-channels.
      Slider* musicVolume;      //!< A Slider for music volume.
      Slider* effectsVolume;    //!< A Slider for effects volume.

      enableSound = new CheckButton(CONFIG_NAME_DISABLE_AUDIO);
      enableSound->setFlagName ("no-sound", 0);
      enableSound->setDescription("Disables Sound", "Check this to disable Sound in Orxonox");
      enableSound->setDefaultValue(0);
      enableSound->saveability();
      audioBox->fill(enableSound);

      Label* audioChannelsLabel = new Label(CONFIG_NAME_AUDIO_CHANNELS);
      audioBox->fill(audioChannelsLabel);
      audioChannels = new Slider(CONFIG_NAME_AUDIO_CHANNELS, 0, 32);
      audioChannels->setFlagName("channels", "c", 32);
      audioChannels->setDescription("Sets the count of channels in the game");
      audioChannels->saveability();
      audioBox->fill (audioChannels);


      Label* musicVolumeLabel = new Label(CONFIG_NAME_MUSIC_VOLUME);
      audioBox->fill(musicVolumeLabel);
      musicVolume = new Slider(CONFIG_NAME_MUSIC_VOLUME, 0, 100);
      musicVolume->setFlagName("music-volume", "m", 80);
      musicVolume->setDescription("Sets the volume of the ingame music");
      musicVolume->saveability();
      audioBox->fill (musicVolume);

      Label* effectsVolumeLabel = new Label (CONFIG_NAME_EFFECTS_VOLUME);
      audioBox->fill (effectsVolumeLabel);
      effectsVolume = new Slider (CONFIG_NAME_EFFECTS_VOLUME, 0, 100);
      effectsVolume->setFlagName ("effects-volume", "e", 80);
      effectsVolume->setDescription("Sets the volune of the ingame SoundEffects");
      effectsVolume->saveability();
      audioBox->fill (effectsVolume);
    }
    audioFrame->fill(audioBox);
  }
  setMainWidget(audioFrame);
}

/**
  *  Destructs the Audio-Stuff
*/
GuiAudio::~GuiAudio()
{
  // nothing to do here.
}
