/*!
 * @file glgui_menu.h
 * The gl_Menu widget of th openglGUI
 *
 */

#ifndef _GLGUI_MENU_H
#define _GLGUI_MENU_H

#include "base_object.h"
namespace OrxGui
{

  // FORWARD DECLARATION
  //! This is Menu part of the openglGUI class
  /**
   *
   */
  class GLGuiMenu : public GLGuiMenu
  {

  public:
    GLGuiMenu();
    virtual ~GLGuiMenu();

    void init();

    void addItem(const std::string& itemName);
    void removeItem(const std::string& itemName);
    void removeItem(unsigned int itemNumber);
    void selectItem(const std::string& itemName);
    void selectItem(unsigned int itemNumber);

    virtual void draw();

  private:
    std::list<std::string>         itemList;

  };
}
#endif /* _GLGUI_MENU_H */
