/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_bar.h"


namespace OrxGui
{

  /**
   * @brief standard constructor
  */
  GLGuiBar::GLGuiBar ()
  {
    this->init();

  }


  /**
   * @brief standard deconstructor
   */
  GLGuiBar::~GLGuiBar()
  {
  }

  /**
   * @brief initializes the GUI-element
   */
  void GLGuiBar::init()
  {
    this->setClassID(CL_GLGUI_BAR, "GLGuiBar");

    this->frontMaterial().setDiffuse(1,1,1);

    this->setSize2D(50, 10);

    this->value = 0.5f;
    this->minimum = 0.0f;
    this->maximum = 1.0f;
  }

  /**
   * @brief draws the GLGuiBar
   */
  void GLGuiBar::draw() const
  {
    this->beginDraw();

    GLGuiWidget::draw();

    this->frontMaterial().select();
    glBegin(GL_QUADS);

    glTexCoord2f(0,0);
    glVertex2f(3.0, 3.0);
    glTexCoord2f(0, value/maximum);
    glVertex2f(3.0, (this->getSizeY2D()-3.0)* (value/maximum));
    glTexCoord2f(1, value/maximum);
    glVertex2f(this->getSizeX2D()-3.0, (this->getSizeY2D()-3.0) * (value/maximum));
    glTexCoord2f(1,0);
    glVertex2f(this->getSizeX2D()-3.0, 3.0);

    glEnd();
    this->endDraw();
  }
}
