#ifndef _SCRIPT_MANAGER_H
#define _SCRIPT_MNAGER_H

#include <list>
#include <string>

#include "script.h"
#include "base_object.h"
#include "luaincl.h"
#include "loading/load_param.h"


//!< Contains the names of all objects in a world and a list of all script files that need the object.
struct worldObject
{
  std::string name;
  std::list<std::string> scriptFiles;
};

class ScriptManager //: public BaseObject
{
 public:
   ScriptManager(std::string& world);
   ~ScriptManager();

  virtual void loadParams(const TiXmlElement* root);

  virtual void tick(float timestep);

  void changeWorld(std::string& newWorld);


  void initScripts(); // initializes all scripts

 private:
   void  init(std::string& world);

   std::list<scriptableObject> objectList; //!< The list of all Objects in a world (read from the *.oxw file of the world)
   std::string currentWorld;


};
#endif
