/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION_REACTION

#include "collision.h"
#include "debug.h"

using namespace std;


/**
 *  standard constructor
 */
Collision::Collision ()
{
  this->entityA = NULL;
  this->entityB = NULL;

  this->bDispatched = false;
  this->entityACollide = false;
  this->entityBCollide = false;
}


/**
 *  standard deconstructor
 */
Collision::~Collision ()
{
}


/**
 * handles the collision events
 */
void Collision::handleCollisionEvents()
{

  this->bDispatched = true;
  this->flushCollisionEvents();
}


/**
 * flushes the CollisionEvent list
 */
void Collision::flushCollisionEvents()
{
  this->entityA = NULL;
  this->entityB = NULL;

  this->entityACollide = false;
  this->entityBCollide = false;

  this->bDispatched = false;

  this->collisionEvents.clear();
}

