/*!
 * @file collision.h
 *  Definition of a collision as a two WE hit each other
 */

#ifndef _COLLISION_H
#define _COLLISION_H

#include "vector.h"
#include <vector>

class WorldEntity;
class BoundingVolume;
class CollisionEvent;

//! A class representing a simple collision
class Collision
{

  public:
    Collision();
    virtual ~Collision();

    /** collides two WorldEntities @param entityA world entity A, @param entityB world entity B, @param bvA volume A @param bvB volumeB */
    inline void collide(WorldEntity* entityA, WorldEntity* entityB) { this->entityA = entityA; this->entityB = entityB; }


    /** @return Collision WorldEntity A */
    inline WorldEntity* getEntityA() const { return this->entityA; }
    /** @return Collision WorldEntity B */
    inline WorldEntity* getEntityB() const { return this->entityB; }
    /** @return true if Entity A collides */
    inline bool isEntityACollide() { return this->entityACollide; }
    /** @return true if Entity B collides */
    inline bool isEntityBCollide() { return this->entityBCollide; }

    /** @returns true if this Collision has already been dispatched */
    inline bool isDispatched() { return this->bDispatched; }

    /** registers a @param event CollisionEvent to take place */
    inline void registerCollisionEvent(CollisionEvent* event) { this->collisionEvents.push_back(event); }
    /** @returns a vector of collision events */
    inline const std::vector<CollisionEvent*>& getCollisionEvents() const { return this->collisionEvents; }



    void handleCollisionEvents();


  private:
    void flushCollisionEvents();


  private:
    WorldEntity*                 entityA;                       //!< the collision body A
    WorldEntity*                 entityB;                       //!< the collision body B
    bool                         entityACollide;                //!< true if entity A is subscribed for collision reaction
    bool                         entityBCollide;                //!< true if entity B is subscribed for collision reaction

    bool                         bDispatched;                   //!< true if this collision has already been dispatched

    std::vector<CollisionEvent*> collisionEvents;               //!< the collision event list
};

#endif /* _COLLISION_H */
