
#include <iostream>

#include "luaincl.h"
#include "lunar.h"
#include "script.h"


    class Account : public BaseObject {
      lua_Number m_balance;
    public:
      static const char className[];
      static Lunar<Account>::RegType methods[];

      Account(lua_State *L)      { m_balance = luaL_checknumber(L, 1); }
      Account(double balance=0)    : m_balance(balance) { }

      void deposit (float value) { m_balance += value; };
      void withdraw(float value) { m_balance -= value; };
      float balance() { return m_balance; };

      int deposit (lua_State *L) { m_balance += luaL_checknumber(L, 1); return 0; }
      int withdraw(lua_State *L) { m_balance -= luaL_checknumber(L, 1); return 0; }
      int balance (lua_State *L) { lua_pushnumber(L, m_balance); return 1; }
      ~Account() { printf("deleted Account (%p)\n", this); }
    };

    const char Account::className[] = "Account";


    #define method(class, name) {#name, &class::name}

    Lunar<Account>::RegType Account::methods[] = {
      {"deposit", new ExecutorLua1<Account, float>(&Account::deposit)},
      {"withdraw", new ExecutorLua1<Account, float>(&Account::withdraw)},
      {"balance", new ExecutorLua0ret<Account, float>(&Account::balance)},
      {0,NULL}
    };


    class Object : public BaseObject {
      public:
        static const char className[];
        static Lunar<Object>::RegType methods[];

        Object(lua_State* L) {callCount = 0; }
        Object(){callCount = 0;};
        ~Object() { printf("deleted Object (%p)\n", this); }

        //lua Interface
        //function that returns a value to lua
        int getCallCount(lua_State* L)
        {
         int calls = getCallCount();
         lua_pushnumber(L,(lua_Number)calls);
         return 1; // return number of values that the function wants to return to lua
        }

         //function that takes an argument from lua
         int takeParam(lua_State* L)
         {
          int param = (int)lua_tonumber(L,-1);
          takeParam(param);
          return 0;
         }

        //meber functions
        void takeParam(int i)
        {
         printf("Lua passed %i to c++\n",i);
        }

        int printName(lua_State* L)
        {
          this->printName();
          return 0;
        }

        void printName()
        {
          callCount ++;
          printf("Hi i'm object %p ! This is the %i. call.\n",this,callCount);
        }

        int getCallCount(){ return callCount; }

      private:
        int callCount;

    };

    const char Object::className[] = "Object";

    Lunar<Object>::RegType Object::methods[] = {
      {"printName", new ExecutorLua0<Object>(&Object::printName)},
      {"getCallCount", new ExecutorLua0ret<Object, int>(&Object::getCallCount)},
      {"takeParam", new ExecutorLua1<Object, int>(&Object::takeParam)},
      {0,0}
    };

    int main(int argc, char *argv[])
    {
      Script script;
      printf("-------------------------- top of the stack:%i\n",lua_gettop(script.getLuaState()));

      // Register classes with the script
      Lunar<Account>::Register(&script);
      Lunar<Object>::Register(&script);

      Object* obj= new Object();
      Account a;
      Account *b = new Account(30);

      // Add instances to the script
      Lunar<Object>::insertObject(&script,obj,"Obj",true);
      Lunar<Account>::insertObject(&script,&a,"a",false);
      Lunar<Account>::insertObject(&script,b,"b",true);
       printf("-------------------------- top of the stack:%i\n",lua_gettop(script.getLuaState()));
      //Load a file
      std::string file(argv[1]);

      if(script.loadFile(file))
        printf("File %s succefully loaded\n", file.c_str());
      printf("-------------------------- top of the stack:%i\n",lua_gettop(script.getLuaState()));
      //execute a function
      printf("----------- main -----------\n");
      std::string main("main");
      if( script.selectFunction(main,3))
       printf("function %s selected\n",main.c_str());

      script.pushParam(3.14159,main);
      script.executeFunction();

      float retf = script.getReturnedFloat();
      printf("main returned %f\n",retf);


      if(script.getReturnedBool())
       printf("main returned true\n");
      else
       printf("main returned false\n");

      int ret = script.getReturnedInt();
      printf("main returned %i\n",ret);

      printf("-------------------------- top of the stack:%i\n",lua_gettop(script.getLuaState()));
      //execute a 2nd function
      printf("----------- test -----------\n");
      std::string test("test");
      if( script.selectFunction(test,0))
       printf("function %s selected\n",test.c_str());

      script.executeFunction();


      //if(argc>1) lua_dofile(script.getLuaState(), argv[1]);
      printf("-------------------------- top of the stack:%i\n",lua_gettop(script.getLuaState()));

      return 0;
    }

