/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "executor_lua.h"

std::string temp;

template<> bool fromLua<bool>(lua_State* state, int index) { return lua_toboolean(state, index); };
template<> int fromLua<int>(lua_State* state, int index) { return (int)lua_tonumber(state, index); };
template<> unsigned int fromLua<unsigned int>(lua_State* state, int index) { return (unsigned int)lua_tonumber(state, index); };
template<> float fromLua<float>(lua_State* state, int index) { return (float)lua_tonumber(state, index); };
template<> char fromLua<char>(lua_State* state, int index) { return (char)lua_tonumber(state, index); };
template<> const std::string& fromLua<const std::string&>(lua_State* state, int index) { temp = lua_tostring(state, index); return temp; };



template<> void toLua<bool>(lua_State* state, bool value) { lua_pushboolean(state, (int) value); };
template<> void toLua<int>(lua_State* state, int value)  { lua_pushnumber(state, (lua_Number) value); };
template<> void toLua<unsigned int>(lua_State* state, unsigned int value){ lua_pushnumber(state, (lua_Number) value); };
template<> void toLua<float>(lua_State* state, float value) { lua_pushnumber(state, (lua_Number) value); };
template<> void toLua<char>(lua_State* state, char value) { lua_pushnumber(state, (lua_Number) value); };
template<> void toLua<const std::string&>(lua_State* state, const std::string& value) {lua_pushstring (state, value.c_str()); }
