/*
	orxonox - the future of 3D-vertical-scrollers

	Copyright (C) 2004 orx

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

### File Specific:
	main-programmer: hdavid, amaechler
	Taken from SkySphere
*/

// TODO: Vektortextur erzeugen und Regionen auswaehlen, Sky...

#include "cloud_effect.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "glincl.h"
#include "material.h"
#include <math.h>
#include "material.h"
#include "state.h"
#include "p_node.h"

#include "parser/tinyxml/tinyxml.h"

using namespace std;

CREATE_FACTORY(CloudEffect, CL_CLOUD_EFFECT);

CloudEffect::CloudEffect(const TiXmlElement* root)
{
	this->setClassID(CL_CLOUD_EFFECT, "CloudEffect");

	this->init();

	if (root != NULL)
		this->loadParams(root);

	this->activate();
}

CloudEffect::~CloudEffect()
{
	this->deactivate();

	//delete this->skyMaterial;
	//gluDeleteQuadric(this->sphereObj);
}


bool CloudEffect::init()
{
  PRINTF(1)("Initializing CloudEffect\n");

  this->sphereObj = gluNewQuadric();
  //this->setParentMode(PNODE_MOVEMENT);

  gluQuadricTexture(this->sphereObj, GL_TRUE);
  gluQuadricOrientation(this->sphereObj, GLU_INSIDE);


  this->setRadius(1900.0);

  mover = 0.0f;

  // Initializing default values
  this->cloudSpeed = 1.0f;
	this->cloudTexture = "pictures/sky/cloud1.jpg";
}


void CloudEffect::loadParams(const TiXmlElement* root)
{
	WeatherEffect::loadParams(root);

	LoadParam(root, "speed", this, CloudEffect, setCloudAnimation);
	LoadParam(root, "texture", this, CloudEffect, setCloudTexture);
}


bool CloudEffect::activate()
{
	PRINTF(0)( "Activating CloudEffect with Material %s\n", this->cloudTexture.c_str());

	this->cloudMaterial = new Material("Sky");
  this->cloudMaterial->setIllum(3);
  this->cloudMaterial->setAmbient(1.0, 1.0, 1.0);
  this->cloudMaterial->setDiffuseMap(this->cloudTexture);
}

bool CloudEffect::deactivate()
{
	PRINTF(0)("Deactivating CloudEffect\n");
}

void CloudEffect::draw() const
{
	/* TODO:
		-Load a texture, for now from an existing image, a cloud texture
		-Blend / Overlay this with a blue sky like in the tutorial
		-Animate it (for now move it along the sky)
	*/

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  // Move sphere along with the camera
  Vector r = State::getCameraNode()->getAbsCoor();
  glTranslatef(r.x, r.y, r.z);

	// Sky movement
	glRotatef(mover, 0, 0, 1);

  cloudMaterial->select();
  gluSphere(this->sphereObj, this->sphereRadius, 20, 20);
  glPopMatrix();
}

void CloudEffect::tick (float dt)
{
  mover = mover + this->cloudSpeed * dt;
}


/**
 *  sets the Radius of the Sphere.
 * @param radius The Radius of The Sphere
*/
void CloudEffect::setRadius(float radius)
{
  this->sphereRadius = radius;
}


