function printf(...) io.write(string.format(unpack(arg))) end

function Account:show()
  printf("Account balance = $%0.02f\n", self:balance())
end

parent = {}

function parent:rob(amount)
  amount = amount or self:balance()
  self:withdraw(amount)
  return amount
end

getmetatable(Account).__index = parent

function main(arg)
  io.write("main received ", arg)
  io.write(" as parameter\n")
  --call member
  Obj:printName()

  --create object

  o = Object()
  o:printName()

  --take returnvalue from c
  callCount = Obj:getCallCount()
  io.write("callCount is now ",callCount)
  io.write("\n")
  
  --pass parameters to a c++ method
  Obj:takeParam(3)

  --print object information
  print('a =', a)
  print('b =', b)
  print('metatable =', getmetatable(a))
  print('Account =', Account)
  table.foreach(Account, print)

  a:show() a:deposit(50.30) a:show() a:withdraw(25.10) a:show()
  Obj:printName()

  return 2,false,2.72
  --debug.debug()
end